define(function(require,exports,module){
	var lotteryFunc={
		creat:function(id, cover, coverType, width, height, drawPercentCallback){
			lotteryFunc.conId = id;
			lotteryFunc.conNode = document.getElementById(lotteryFunc.conId);
			lotteryFunc.cover = cover;
			lotteryFunc.coverType = coverType;
			lotteryFunc.background = null;
			lotteryFunc.backCtx = null;
			lotteryFunc.mask = null;
			lotteryFunc.maskCtx = null;
			lotteryFunc.lottery = null;
		    lotteryFunc.lotteryType = 'image';
		    lotteryFunc.width = width || 300;
		    lotteryFunc.height = height || 150;
		    lotteryFunc.clientRect = null;
		    lotteryFunc.drawPercentCallback = drawPercentCallback;
		},
		createElement: function (tagName, attributes) {
	        var ele = document.createElement(tagName);
	        for (var key in attributes) {
	            ele.setAttribute(key, attributes[key]);
	        }
	        return ele;
	    },
	    getTransparentPercent: function(ctx, width, height) {
	        var imgData = ctx.getImageData(0, 0, width, height),
	            pixles = imgData.data,
	            transPixs = [];
	        for (var i = 0, j = pixles.length; i < j; i += 4) {
	            var a = pixles[i + 3];
	            if (a < 128) {
	                transPixs.push(i);
	            }
	        }
	        return (transPixs.length / (pixles.length / 4) * 100).toFixed(2);
	    },
	    resizeCanvas: function (canvas, width, height) {
	        canvas.width = width;
	        canvas.height = height;
	        canvas.getContext('2d').clearRect(0, 0, width, height);
	    },
	    drawPoint: function (x, y) {
	        lotteryFunc.maskCtx.beginPath();
	        var radgrad = lotteryFunc.maskCtx.createRadialGradient(x, y, 0, x, y, 30);
	        radgrad.addColorStop(0, 'rgba(0,0,0,0.6)');
	        radgrad.addColorStop(1, 'rgba(255, 255, 255, 0)');
	        lotteryFunc.maskCtx.fillStyle = radgrad;
	        lotteryFunc.maskCtx.arc(x, y, 30, 0, Math.PI * 2, true);
	        lotteryFunc.maskCtx.fill();
	        if (lotteryFunc.drawPercentCallback) {
	            lotteryFunc.drawPercentCallback.call(null, lotteryFunc.getTransparentPercent(lotteryFunc.maskCtx, lotteryFunc.width, lotteryFunc.height));
	        }
	    },
	    bindEvent: function () {
	        var _lotteryFunc = lotteryFunc;
	        var device = (/android|webos|iphone|ipad|ipod|blackberry|iemobile|opera mini/i.test(navigator.userAgent.toLowerCase()));
	        var clickEvtName = device ? 'touchstart' : 'mousedown';
	        var moveEvtName = device? 'touchmove': 'mousemove';
	        if (!device) {
	            var isMouseDown = false;
	            document.addEventListener('mouseup', function(e) {
	                isMouseDown = false;
	            }, false);
	        } else {
	            document.addEventListener("touchmove", function(e) {
	                if (isMouseDown) {
	                    e.preventDefault();
	                }
	            }, false);
	            document.addEventListener('touchend', function(e) {
	                isMouseDown = false;
	            }, false);
	        }
	        lotteryFunc.mask.addEventListener(clickEvtName, function (e) {
	            isMouseDown = true;
	            var docEle = document.documentElement;
	            if (!_lotteryFunc.clientRect) {
	                _lotteryFunc.clientRect = {
	                    left: 0,
	                    top:0
	                };
	            }
	            var x = (device ? e.touches[0].clientX : e.clientX) - _lotteryFunc.clientRect.left + docEle.scrollLeft - docEle.clientLeft;
	            var y = (device ? e.touches[0].clientY : e.clientY) - _lotteryFunc.clientRect.top + docEle.scrollTop - docEle.clientTop;
	            _lotteryFunc.drawPoint(x, y);
	        }, false);

	        lotteryFunc.mask.addEventListener(moveEvtName, function (e) {
	            if (!device && !isMouseDown) {
	                return false;
	            }
	            var docEle = document.documentElement;
	            if (!_lotteryFunc.clientRect) {
	                _lotteryFunc.clientRect = {
	                    left: 0,
	                    top:0
	                };
	            }
	            var x = (device ? e.touches[0].clientX : e.clientX) - _lotteryFunc.clientRect.left + docEle.scrollLeft - docEle.clientLeft;
	            var y = (device ? e.touches[0].clientY : e.clientY) - _lotteryFunc.clientRect.top + docEle.scrollTop - docEle.clientTop;
	            _lotteryFunc.drawPoint(x, y);
	        }, false);
	    },
	    drawLottery: function () {
	        lotteryFunc.background = lotteryFunc.background || lotteryFunc.createElement('canvas', {
	            style: 'position:absolute;left:0;top:0;'
	        });
	        lotteryFunc.mask = lotteryFunc.mask || lotteryFunc.createElement('canvas', {
	            style: 'position:absolute;left:0;top:0;'
	        });

	        if (lotteryFunc.conNode&&!lotteryFunc.conNode.innerHTML.replace(/[\w\W]| /g, '')) {
	            lotteryFunc.conNode.appendChild(lotteryFunc.background);
	            lotteryFunc.conNode.appendChild(lotteryFunc.mask);
	            lotteryFunc.clientRect = lotteryFunc.conNode ? lotteryFunc.conNode.getBoundingClientRect() : null;
	            lotteryFunc.bindEvent();
	        }

	        lotteryFunc.backCtx = lotteryFunc.backCtx || lotteryFunc.background.getContext('2d');
	        lotteryFunc.maskCtx = lotteryFunc.maskCtx || lotteryFunc.mask.getContext('2d');

	        if (lotteryFunc.lotteryType == 'image') {
	            var image = new Image(),
	                _lotteryFunc = lotteryFunc;
	            image.onload = function () {
	                _lotteryFunc.width = lotteryFunc.width;
	                _lotteryFunc.height = lotteryFunc.height;
	                _lotteryFunc.resizeCanvas(_lotteryFunc.background, lotteryFunc.width, lotteryFunc.height);
	                _lotteryFunc.backCtx.drawImage(lotteryFunc, 0, 0);
	                _lotteryFunc.drawMask();
	            }
	            image.src = lotteryFunc.lottery;
	        } else if (lotteryFunc.lotteryType == 'text') {
	            lotteryFunc.width = lotteryFunc.width;
	            lotteryFunc.height = lotteryFunc.height;
	            lotteryFunc.resizeCanvas(lotteryFunc.background, lotteryFunc.width, lotteryFunc.height);
	            lotteryFunc.backCtx.save();
	            lotteryFunc.backCtx.fillStyle = '#FFF';
	            lotteryFunc.backCtx.fillRect(0, 0, lotteryFunc.width, lotteryFunc.height);
	            lotteryFunc.backCtx.restore();
	            lotteryFunc.backCtx.save();
	            var fontSize = 24;
	            lotteryFunc.backCtx.font = 'Bold ' + fontSize + 'px 微软雅黑';
	            lotteryFunc.backCtx.textAlign = 'center';
	            lotteryFunc.backCtx.fillStyle = '#F60';
	            lotteryFunc.backCtx.fillText(lotteryFunc.lottery, lotteryFunc.width / 2, lotteryFunc.height / 2 + fontSize / 2);
	            lotteryFunc.backCtx.restore();
	            lotteryFunc.drawMask();
	        }
	    },
	    drawMask: function() {
	        lotteryFunc.resizeCanvas(lotteryFunc.mask, lotteryFunc.width, lotteryFunc.height);
	        if (lotteryFunc.coverType == 'color') {
	            lotteryFunc.maskCtx.fillStyle = lotteryFunc.cover;
	            lotteryFunc.maskCtx.fillRect(0, 0, lotteryFunc.width, lotteryFunc.height);
	            lotteryFunc.maskCtx.globalCompositeOperation = 'destination-out';
	        } else if (lotteryFunc.coverType == 'image'){
	            var image = new Image(),
	                _lotteryFunc = lotteryFunc;
	            image.onload = function () {
	                _lotteryFunc.maskCtx.drawImage(lotteryFunc, 0, 0);
	                _lotteryFunc.maskCtx.globalCompositeOperation = 'destination-out';
	            }
	            image.src = lotteryFunc.cover;
	        }
	    },
	    init: function (lottery, lotteryType) {
	        lotteryFunc.lottery = lottery;
	        lotteryFunc.lotteryType = lotteryType || 'image';
	        lotteryFunc.drawLottery();
	    }
	}
	module.exports=lotteryFunc;
});