define(function(require,exports,module){
	var cityUtils=require('cityutils');
	var toast=require('toast');
	var clone=require("clone");
	var identityCodeValidi=require("identityCodeValidi");
	var urlParam=require('urlParam');
	var addrManageFunc={
		tempAddresses:[],
		selectAddress:{},
		init:function(obj){
			//addrManageFunc.tempAddresses=obj.addresses;// 地址列表集合
			addrManageFunc.tempAddresses=obj.addresses;// 地址列表集合
		    /*初始化 地址*/
		    if(addrManageFunc.tempAddresses.length!=0){
			    for(var i=0;i<addrManageFunc.tempAddresses.length;i++){
					var address=addrManageFunc.tempAddresses[i];
					addAddress(address,i);
				}
		    } else {
		    	$("#yourAddrlist").hide();
		    	$("#emptyAddress").show();
		    }
		    /*根据传递的数据 添加地址列表的数据isDefault=true 是默认*/
		    function addAddress(address,pointer){
		    	if(address == null){
		    		return false;
		    	}
		    	//省市区
		    	var addDetail = cityUtils.getAddr(address.cityCode);
		    	var div="<div class='ditem";
	    		div+=" '>"
					+"		<div class='addritem'  id="+address.customerAddressId+"  data-pointer='"+pointer+"'  >"
					+			"<p>"+address.name+'&nbsp;&nbsp;&nbsp;'+address.phone+"</p>";
				div+=			"<p>"+addDetail+address.address+"&nbsp;&nbsp;&nbsp;</p>"
					+"		</div>"
					+"  	<div class='editaddrbar'>"
					+"			<div class='check_default'>"
					if(address.isDefault == true || address.isDefault == "true"){
						div += "<span></span>默认地址";
					} else {
						div += "<input class='setdefault' type='checkbox'>设为默认地址";
					}
				div	+="          </div>"
					+"          <a class='editaddr' data-id="+address.customerAddressId+">编辑</a>"
					+"			<a class='deladdr'>删除</a>";
				div+="		</div>"
					+"	</div>";
				$("#yourAddrlist").prepend(div);
		    }
		    /*初始化  省/直辖市 ,城市, 县/区 下拉框 值 以及其  change 事件*/
			var options={
				province	:'yourAddrProvince',			//	省/直辖市
				city		:'yourAddrCity',			//	市
				county		:'yourAddrArea',			//	县/区
				defaultCitys:obj.defaultCitys||'',			//	默认城市 代码
			};
			cityUtils.init(options);
			//新建收货地址
			$(".addrmanage_page").on('click',".empty_address .btn_new_address",function(e){
				e.preventDefault();
				//清空地址输入
				 $("#setDefaultAddr").prop("checked",false);
	        	$("#yourAddrName").val("");
	     	    $("#yourAddrPhone").val("");
	     	    $("#yourAddrProvince").val("10");
	     	    $("#yourAddrProvince").change();
	     	    $(".addr_group").hide();
	     	    $("#yourAddrDetails").val("");
	     	    $("#yourAddr").val("");
	     	    $("#yourIdCard").val("");
	     	    //显示对应页面
				$("#emptyAddress").hide();
				$("#editAddress").show();
				$("#yourAddrlist").hide();
				$(window).scrollTop(0);
				window.location.hash="newAddress";
			});
			$(".addrmanage_page").on('click',"#yourAddrlist .btn_new_address",function(e){
				e.preventDefault();
				//清空地址输入
				 $("#setDefaultAddr").prop("checked",false);
	        	$("#yourAddrName").val("");
	     	    $("#yourAddrPhone").val("");
	     	    $("#yourAddrProvince").val("10");
	     	    $("#yourAddrProvince").change();
	     	    $(".addr_group").hide();
	     	    $("#yourAddrDetails").val("");
	     	    $("#yourAddr").val("");
	     	    $("#yourIdCard").val("");
	     	    //显示对应页面
				$("#yourAddrlist").hide();
				$("#editAddress").show();
				window.location.hash="newAddress";
			});
			 /*保存新地址*/
		    $(".btn_address_save").on('click', function(event) {
		        event.preventDefault();
		        var $_this = $(this);
				/*获取对应的 地址信息*/
		        var  addrName = $.trim($("#yourAddrName").val());
		        var  addrPhone = $.trim($("#yourAddrPhone").val());
		        var  addrProvince = $.trim($("#yourAddrProvince").val());
		        var  addrCity = $.trim($("#yourAddrCity").val());
		        var  addrArea = $.trim($("#yourAddrArea").val());
		        var  addrDetails = $.trim($("#yourAddrDetails").val());
		        var idCard = $.trim($("#yourIdCard").val());
		        var district = $.trim($("#yourAddr").val());
						addrName = HtmlUtil.htmlEncodeByRegExp(addrName);
						addrDetails = HtmlUtil.htmlEncodeByRegExp(addrDetails);
		        //如果是编辑地址，有地址id
		        var addrId = $("#createAddrwrap").attr("data-id");
		        /*必填等验证*/
		        if(addrName == "" || addrName == " "){
		            toast(1000,"收货人不能为空");
		            return false;
		        }
		        if(addrPhone == "" || addrPhone == " "){
		            toast(1000,"电话号码不能为空");
		            return false;
		        }
		        var phoneRegExp = new RegExp("^[1][3456789][0-9]{9}$");
		        if(addrPhone.indexOf('-') == -1){
		        	if(isNaN(addrPhone)){
		        		toast(1000,"请输入正确的电话号码");
			            return false;
		        	}else if(!phoneRegExp.test(addrPhone)){
		        		toast(1000,"请输入正确的电话号码");
			            return false;
		        	}
		        }else{
		        	if(isNaN(parseInt(addrPhone.split('-')[0]))||isNaN(parseInt(addrPhone.split('-')[1]))){
		        		toast(1000,"请输入正确的电话号码");
			            return false;
		        	}else if(!phoneRegExp.test(addrPhone)){
		        		toast(1000,"请输入正确的电话号码");
			            return false;
		        	}
		        }
		        if(addrDetails == "" || addrDetails == ""){
		            toast(1000,"地址不能为空");
		            return false;
		        }
		        if($("#yourIdCard") && $("#yourIdCard").length>0){//如果需要填写身份证
		        	if(idCard==""){
			        	toast(1000,"身份证号码不能为空");
			            return false;
		        	}
		        	var idcardValid=identityCodeValidi(idCard);
		        	if(!idcardValid.result){
		        		toast(1000,"身份证号核验未通过，请重新输入");
			            return false;
		        	}
		        }
		        $_this.attr("disabled","true");
			    $_this.html("保存中...");
		        /*ajax 保存 请求参数 ,提取 用于 encodeRUI  方便 处理 中文乱码*/
		        var paramter='?addrName='+addrName+"&addrDetails="+addrDetails;
		        /*ajax 请求参数*/
		        var datas= {
		            	addrPhone:addrPhone,
		            	addrProvince:addrProvince,
		            	addrCity:addrCity,
		            	addrArea:addrArea,
		            	addressId:addrId,
		            	idCard:idCard,
		            	district:district,
		            	isDefault:$("#setDefaultAddr").is(":checked")==true?"true":"false",
            			address:addrDetails
		        };
		        /*执行请求,并更新 数据列表*/
		        ajaxUpdateAddress(paramter,datas);
		    });
		    //设置默认地址
		    $("#yourAddrlist").on('click', '.setdefault', function(event) {
				var pointer= $(this).parent().parent().siblings(".addritem").attr("data-pointer");
				var data=addrManageFunc.tempAddresses[parseInt(pointer)];
				var paramter='?addrName='+data.name+"&addrDetails="+data.address;
				var datas= {
	            	addrPhone		:data.phone,								//电话
	            	addrProvince	:data.cityCode.toString().substring(0,2),			// 省/直辖市 / code
	            	addrCity		:data.cityCode.toString().substring(2,4),					// 城/市 代码
	            	addrArea		:data.cityCode.toString().substring(4),				// 县 /区 代码
	            	isDefault		:true,
	            	district		:data.address,
	            	addressId		:data.customerAddressId,
	            	address			:data.address
				};
				 ajaxUpdateAddress(paramter,datas,"setDefault");				//ajax 请求 更新
		    });
		    var ajaxUpdateAddress=function(paramter,datas,actionType){
		    	var newAddr = {
	    			address: datas.address,
		    		cardNo: datas.idCard,
		    		cityCode: datas.addrProvince.toString()+datas.addrCity.toString()+datas.addrArea.toString(),
		    		customerAddressId: datas.addressId,
		    		isDefault: datas.isDefault,
		    		name:  $.trim($("#yourAddrName").val()),
		    		phone: datas.addrPhone
		    	};
		    	var subUrl=ctx+'/address/saveAddress.do';
		    	// 处理中文乱码
		    	if(paramter){
		    		subUrl+=paramter;
		    		subUrl=encodeURI((encodeURI(subUrl)));
		    	}
		    	$.ajax({
		            url: subUrl,
		            type: "POST",
		            async:false,
		            data:newAddr,
		            datatype:"json",
		            success: function(datajson) {
		                if(datajson.code==0){
		                	if(actionType=="setDefault"){//设置默认
		                		toast(1000,"默认地址设置成功");
		                		$(".check_default").html('<input class="setdefault" type="checkbox">设为默认地址');
		                		$(".addritem[id='"+datas.addressId+"']").parent().find(".check_default").html("<span></span>默认地址")
		                	}else{//编辑或者新增
		                		toast(1000,"地址设置成功");
			                	$(".btn_address_save").removeAttr("disabled");
			                	$(".btn_address_save").html("保存地址");
			                	$("#editAddress").hide();
			                	$("#yourAddrlist").show();
			                    $("#yourAddrlist").html("");		//清空 地址列表,根据数据 从新 更新
			                    if(datas.addressId){ //编辑状态
			                    	//addrManageFunc.tempAddresses.push(datajson.result);//回调的 更新之后的 所有地址列表数据
			                    	 for(var i=0;i<addrManageFunc.tempAddresses.length;i++){
					            			if(datas.addressId == addrManageFunc.tempAddresses[i].customerAddressId){
					            				newAddr.createTime = addrManageFunc.tempAddresses[i].createTime;
					            				addrManageFunc.tempAddresses.splice(i,1);
					            			}
				            		}
			                    	if(datas.isDefault == "true"||datas.isDefault == true){

			                    		for(var i=0;i<addrManageFunc.tempAddresses.length;i++){
			                    			addrManageFunc.tempAddresses[i].isDefault = "false";
			                    		}
			                    	}
			                    	 addrManageFunc.tempAddresses.push(newAddr);
			                    }else{
			                    	if(datas.isDefault == "true"||datas.isDefault == true){
			                    		for(var i=0;i<addrManageFunc.tempAddresses.length;i++){
			                    			addrManageFunc.tempAddresses[i].isDefault = "false";
			                    		}
			                    	}
			                    	addrManageFunc.tempAddresses.push(datajson.result);//回调的 更新之后的 所有地址列表数据
			                    }

			                    for(var i=0;i<addrManageFunc.tempAddresses.length;i++){
			            			var address=addrManageFunc.tempAddresses[i];
			            			addAddress(address,i);
			            		}
			                    $("#yourAddrlist").append('<button class="btn-orange btn_new_address">添加新地址</button>');
			                    if(addrManageFunc.tempAddresses.length>=5){
			                    	$("#yourAddrlist .btn_new_address").hide();
			                    }
			                    //新增地址完成之后 ,从新初始化初始化
			    	        	$("#yourAddrName").val("");
			    	     	    $("#yourAddrPhone").val("");
			    	     	    $("#yourAddrProvince").val("10");
			    	     	    $("#yourAddrProvince").change();
			    	     	    $(".addr_group").hide();
			    	     	    $("#yourAddrDetails").val("");
			    	     	    $("#yourIdCard").val("");
			    	     	    $("#yourAddr").val("");
			    	     	    if(urlParam.getUrlParam('fromUrl')){
			    	     	    	window.location.href = ctx + '/address/main.do?methodName=takeAway&storeid='+WX.storeid+'&fromUrl='+urlParam.getUrlParam('fromUrl');
			    	     	    }
		                	}
		                }else{
		                	toast(1000,"更新地址失败,请刷新页面,稍后重试!");
		                	$(".btn_address_save").removeAttr("disabled");
		                	$(".btn_address_save").html("保存地址");
		                }
		            },
		            error: function() {
		            	toast(1000,"更新地址失败,请刷新页面,稍后重试!");
		            	$(".btn_address_save").removeAttr("disabled");
	                	$(".btn_address_save").html("保存地址");
		            }
		        });
		    };
		    /*选择显示城市列表*/
			$(".addr_area").on('click',function(e){
				if($(".addr_group").is(":hidden")){
					$("#yourAddr").css("border-bottom-width","0");
				}else{
					$("#yourAddr").css("border-bottom-width","1px");
				}
				$(".input.your_addr").find(".addr_group").slideToggle();
				//var addrFull = $("#yourAddrProvince").find("option:selected").text()+$("#yourAddrCity").find("option:selected").text()+$("#yourAddrArea").find("option:selected").text();
				//$(".input.your_addr").find("input").val(addrFull);
				var _province=$("#yourAddrProvince").find("option:selected").text();
				var _city=$("#yourAddrCity").find("option:selected").text();
				var _area=$("#yourAddrArea").find("option:selected").text();
				var _val=$("#yourAddrProvince").find("option:selected").val();
				if(_val === '10'){
					$(".input.your_addr").find("input").val('请选择');
				}else{
					$(".input.your_addr").find("input").val(_province+_city+_area);
				}
			});
			//根据选择的城市拼出地址
			$(".addr_group select").change(function(){
				 $("#yourAddr").val(cityUtils.getAddr($("#yourAddrProvince").val()+$("#yourAddrCity").val()+$("#yourAddrArea").val()));
			});
			//编辑地址
		    $(".addrmanage_page").on('click',".editaddr",function(event){
		    	event.preventDefault();
		    	 $("#setDefaultAddr").prop("checked",false);
		    	 var $_this = $(this);
		    	 var addrId = $_this.attr("data-id");
		    	 var cur_addr = getAddrId(addrId);
		    	 var options={
							province	:'yourAddrProvince',			//	省/直辖市
							city		:'yourAddrCity',			//	市
							county		:'yourAddrArea',			//	县/区
							defaultCitys:cur_addr.cityCode.toString().slice(0,2)+"|"+cur_addr.cityCode.toString().slice(2,4)+"|"+cur_addr.cityCode.toString().slice(4,6),			//	默认城市 代码
						};
		    	 cityUtils.init(options);
		    	 $("#createAddrwrap").attr("data-id",addrId);
		    	 $("#yourAddrName").val(cur_addr.name);
		    	 $("#yourAddrPhone").val(cur_addr.phone);
	    		 $("#yourIdCard").val(cur_addr.cardNo);
		    	 $("#yourAddr").val(cityUtils.getAddr(cur_addr.cityCode));
		    	 $("#yourAddrDetails").val(cur_addr.address);
		    	 if(cur_addr.isDefault == "true" || cur_addr.isDefault == true){
		    		 $("#setDefaultAddr").prop("checked",true);
		    	 }else {
		    		 $("#setDefaultAddr").prop("checked",false);
		    	 }
		    	 $("#yourAddrlist").hide();
		    	 $("#editAddress").show();
		    	 $(window).scrollTop(0);
		    	 window.location.hash="editAddress";
		    });
		    //根据地址id获取地址信息
		    function getAddrId(id){
		    	for(var i = 0;i<addrManageFunc.tempAddresses.length;i++){
		    		if(addrManageFunc.tempAddresses[i]){
		    			if(addrManageFunc.tempAddresses[i].customerAddressId == id){
			    			return addrManageFunc.tempAddresses[i];
			    		}
		    		}
		    	}
		    }
		    /*删除地址事件*/
		    $("#yourAddrlist").on('click', '.deladdr', function(event) {
		    	event.preventDefault();
				var div=$(this).parent().parent();//获取 当前操作 地址的 div 标签
				var addrId = $(this).parent().siblings(".addritem").attr("id");	//获取 要删除的地址的ID
				var pointer= $(this).parent().siblings(".addritem").attr("data-pointer");	//获取 当前地址对应 数据信息 在 addresses 数据 数组内的 指针
		        $.ajax({
		            url: ctx+'/address/deleteAddress.do',
		            type: "POST",
		            async:false,
		            datatype:"json",
		            data: {addressId:addrId},
		            success: function(datajson) {
		                if(datajson.code==0){
		                	addrManageFunc.tempAddresses.splice(parseInt(pointer),1);//删除地址数据					//如果不是 默认地址,则 清空 数组元素里面 对应 指针的值
	                		div.remove();//删除当前 地址 div 标签
	                		toast(1000,"删除成功");
	                		if($("#yourAddrlist .ditem").length<5){
	                			$("#yourAddrlist .btn_new_address").show();
	                		}
	                		if($("#yourAddrlist .ditem").length==0){
	                			$("#yourAddrlist").hide();
                				$(".empty_address").show();
	                		}
		                }else{
		                	toast(1000,"删除失败,请刷新页面,重试!");
		                }
		            },
		            error: function() {
		            	toast(1000,"删除失败,请刷新页面,重试!");
		            }

		        });
		    });
		}
	};
	module.exports=addrManageFunc;
});
