define(function (require, exports, module) {
    var $ = require('jquery'),
        selectSku = require('selectSku'),
        toast = require('toast'),
        $tempProduct = null,
        tempSelectSku = {};
    module.exports = {
        init: function (config, callback) { // 传参商品数据和选择商品回调
            $(function () {
                $('.select-product-panel').remove();
                // 生成商品选择列表
                var productListHtml =
                    '<div class="select-product-panel">';
                if (!config.readonly) {
                    productListHtml +=
                        '<div class="select-product-head">请选择一件赠品</div>';
                }
                productListHtml +=
                        '<div class="select-product-content">';
                $.each(config.goodsList, function (index, product) {
                    productListHtml +=
                            '<div class="select-product-item">';
                    if (!config.readonly) {
                        productListHtml +=
                                '<input type="radio" name="giftProductCheck" class="select-product-choose">';
                    }
                    productListHtml +=
                                '<div class="select-product-info">' +
                                    '<div class="select-product-image">' +
                                        '<img src="' + config.imageDomin + product.indexUrl + '">' +
                                    '</div>' +
                                    '<div class="select-product-detail">' +
                                        '<p class="select-product-name">' + product.goodsName + '</p>';
                    if (!config.readonly) {
                        productListHtml +=
                                        '<div class="select-product-sku">' +
                                            '<div>' +
                                                '<p>请选择规格</p>' +
                                            '</div>' +
                                            '<button class="select-product-sku-button" data-id="' + product.id + '" disabled>选择规格</button>' +
                                        '</div>';
                    }
                    productListHtml +=
                                    '</div>' +
                                '</div>' +
                            '</div>';
                });
                productListHtml +=
                        '</div>';
                if (!config.readonly) {
                    productListHtml +=
                        '<button class="select-product-confirm">确定</button>';
                } else {
                    productListHtml +=
                        '<button class="select-product-cancel">返回</button>';
                }
                productListHtml +=
                    '</div>';
                $('body').append(productListHtml);

                $('.select-product-choose').click(function (e) { // 禁用input默认勾选事件
                    e.stopPropagation();
                });
                $('.select-product-choose').on('change', function () {
                    if ($(this).prop('checked')) {
                        $('.select-product-item').find('.select-product-sku-button').attr('disabled', true);
                        $(this).parents('.select-product-item').find('.select-product-sku-button').removeAttr('disabled');

                        $('.select-product-item').find('.select-product-sku>div').html('<p>请选择规格</p>');
                        tempSelectSku = null; // 重置选择的规格
                    }
                });
                $('.select-product-item').click(function () { // 勾选商品
                    $(this).find('.select-product-choose').click();
                });
                $('.select-product-sku-button').click(function (e) { // 选择规格
                    e.stopPropagation();
                    $tempProduct = $(this).parents('.select-product-item');
                    selectSku.showSkus({
                        productId: $(this).attr('data-id'), // 商品id
                        staticNum: 1 // 固定数量（1个）
                    }, function (skuSelect) {
                        selectSku.hideSkus();
                        var specHtml = '';
                        $.each(skuSelect.specText, function (index, spec) {
                            specHtml += '<p>' + spec + '</p>'
                        });
                        $tempProduct.find('.select-product-sku>div').html(specHtml);
                        tempSelectSku = skuSelect;
                        console.log(tempSelectSku)
                    })
                });
                $('.select-product-confirm').click(function () { // 确定选择赠品
                    if ($('.select-product-choose:checked').length === 0) {
                        toast(1500, '请选择赠品');
                        return false;
                    }
                    if (!tempSelectSku) {
                        toast(1500, '请选择赠品规格');
                        return false;
                    }
                    callback.call(null, config.goodsList[$('.select-product-choose').index($('.select-product-choose:checked'))], tempSelectSku, config.imageDomin);
                    $('.select-product-panel').remove();
                })
                $('.select-product-cancel').click(function () {
                    $('.select-product-panel').remove();
                })
            })
        }
    }
})