define(function(require,exports,module){
    var cityUtils=require('cityutils');
    var toast=require('toast');
    var clone=require("clone");
    var identityCodeValidi=require("identityCodeValidi");
    var addressFunc={
        tempAddresses:[],//地址列表集合
        selectAddress:{},//当前选中地址
        tempDeliveryAddress:{},
        tempTakeoutAddress:{},
        init:function(obj){
            addressFunc.tempAddresses=obj.addresses;// 地址列表集合
            $("#yourAddrlist .ditem").remove();
            /*初始化 地址*/
            if(addressFunc.tempAddresses&&addressFunc.tempAddresses.length!=0){//如果有地址数据
                for(var i=0;i<addressFunc.tempAddresses.length;i++){//拼接地址列表
                    var address=addressFunc.tempAddresses[i];
                    addAddress(address,i);
                    if(address.isDefault == "true" || address.isDefault == true){//如果有默认地址，当前选中的地址为默认地址
                        addressFunc.selectAddress=address;
                    }
                }
                if(addressFunc.selectAddress=={})//如果没有默认地址，当前选中为第一个地址
                    addressFunc.selectAddress=addressFunc.tempAddresses[0];
            }else {//如果没有地址数据，显示提示地址为空的页面
                $("#yourAddrlist").hide();
                $("#emptyAddress").show();
            }
            /*根据传递的数据 添加地址列表的数据。isDefault=true是默认*/
            function addAddress(address,pointer){
                if(address == null){
                    return
                }
                var addDetail = cityUtils.getAddr(address.cityCode);
                var div="<div class='ditem";
                if(address.isDefault||(!address.isDefault&&pointer==0))//是默认地址或者没有默认地址是第一个，则添加选中class
                    div+=" selected"
                if(WX.orderAjaxDatas.postType == 3 && address.canReach === false){
                    div+=" disabled"
                }
                div+=" '>"
                    +"		<div class='addritem'  id="+address.customerAddressId+"  data-pointer='"+pointer+"'>"
                    +"			<p>"+address.name+"&nbsp;&nbsp;&nbsp;"+address.phone+"</p>";
                div+=			"<p>"+address.address+"&nbsp;&nbsp;&nbsp;</p>"
                    +"		</div>"
                    +"  	<div class='editaddrbar'>"
                    +"			<div class='check_default'>"
                if(address.isDefault == true || address.isDefault == "true"){
                    div += "<span></span>默认地址";
                }
                else{
                    div += "<input class='setdefault' type='checkbox'>设为默认地址";
                }
                div += "</div>"
                    +"          <a class='editaddr' data-id="+address.customerAddressId+">编辑</a>"
                    +"			<a class='deladdr'>删除</a>";
                div+="		</div>"
                    +"	</div>";
                $("#yourAddrlist").prepend(div);
            }
            /*初始化  省/直辖市 ,城市, 县/区 下拉框 值 以及其  change 事件*/
            var options={
                province	:'yourAddrProvince',			//	省/直辖市
                city		:'yourAddrCity',			//	市
                county		:'yourAddrArea',			//	县/区
                defaultCitys:obj.defaultCitys||'',			//	默认城市 代码
            };
            cityUtils.init(options);
            /*弹出框地址选择初始化*/
            var toastOptions={
                province	:'toastAddrProvince',			//	省/直辖市
                city		:'toastAddrCity',			//	市
                county		:'toastAddrArea',			//	县/区
                defaultCitys:obj.defaultCitys||'',			//	默认城市 代码
            };
            cityUtils.init(toastOptions);
            /*新增地址点击事件*/
            $("#address_div").on('click',"#emptyAddress .btn_new_address",function(e){
                e.preventDefault();
                //清空地址输入
                $("#createAddrwrap").attr("data-id","");//新增清除id
                $("#yourAddrName").val("");
                $("#yourAddrPhone").val("");
                $("#yourAddrProvince").val("10");
                $("#yourAddrProvince").change();
                $(".addr_group").hide();
                $("#yourAddrDetails").val("");
                //$("#yourAddrZip").val("");
                $("#yourAddr").val("");
                $("#yourIdCard").val("");
                //显示对应页面
                $("#emptyAddress").hide();
                $("#editAddress").show();
                $("#yourAddrlist").hide();
                $(window).scrollTop(0);
                window.location.hash="newAddress";
            });
            $("#address_div").on('click',"#yourAddrlist .btn_new_address",function(e){
                e.preventDefault();
                //清空地址输入
                $("#createAddrwrap").attr("data-id","");//新增清除id
                $("#yourAddrName").val("");
                $("#yourAddrPhone").val("");
                $("#yourAddrProvince").val("10");
                $("#yourAddrProvince").change();
                $(".addr_group").hide();
                $("#yourAddrDetails").val("");
                //$("#yourAddrZip").val("");
                $("#yourAddr").val("");
                $("#yourIdCard").val("");
                //显示对应页面
                $("#yourAddrlist").hide();
                $("#editAddress").show();
                window.location.hash="newAddress";
                $("#editaddress_title").hide();
            });
            /*保存并使用按钮事件*/
            $(".btn_address_save,.btn_toast_address_save").on('click', function(event) {
                event.preventDefault();
                var $_this = $(this);
                if($_this.hasClass('btn_address_save')){
                    /*获取填写的地址信息*/
                    var addrName = $("#yourAddrName").val();
                    var addrPhone = $("#yourAddrPhone").val();
                    var addrProvince =$("#yourAddrProvince").val();
                    var addrCity = $("#yourAddrCity").val();
                    var addrArea = $("#yourAddrArea").val();
                    var addrDetails = $("#yourAddrDetails").val();
                    //var addrZip = $("#yourAddrZip").val();
                    var idCard=$("#yourIdCard").val();
                    var district=$("#yourAddr").val();
                    //如果是编辑地址，有地址id
                    var addrId = $("#createAddrwrap").attr("data-id");
                }
                if($_this.hasClass('btn_toast_address_save')){
                    /*获取弹出框填写的地址信息*/
                    var addrName = $("#toastAddrName").val();
                    var addrPhone = $("#toastAddrPhone").val();
                    var addrProvince =$("#toastAddrProvince").val();
                    var addrCity = $("#toastAddrCity").val();
                    var addrArea = $("#toastAddrArea").val();
                    var addrDetails = $("#toastAddrDetails").val();
                    //var addrZip = $("#yourAddrZip").val();
                    var idCard=$("#toastIdCard").val();
                    var district=$("#toastAddr").val();
                }
                addrName = HtmlUtil.htmlEncodeByRegExp(addrName);
                addrDetails = HtmlUtil.htmlEncodeByRegExp(addrDetails);
                /*必填等验证*/
                if(addrName == "" || addrName == " "){
                    toast(1000,"收货人不能为空");
                    return false;
                }
                if(addrPhone == "" || addrPhone == " "){
                    toast(1000,"电话号码不能为空");
                    return false;
                }
                var phoneRegExp = new RegExp("^[1][3456789][0-9]{9}$");
                if(addrPhone.indexOf('-') == -1){
                    if(isNaN(addrPhone)){
                        toast(1000,"请输入正确的电话号码");
                        return false;
                    }else if(!phoneRegExp.test(addrPhone)){
                        toast(1000,"请输入正确的电话号码");
                        return false;
                    }
                }else{
                    if(isNaN(parseInt(addrPhone.split('-')[0]))||isNaN(parseInt(addrPhone.split('-')[1]))){
                        toast(1000,"请输入正确的电话号码");
                        return false;
                    }else if(!phoneRegExp.test(addrPhone)){
                        toast(1000,"请输入正确的电话号码");
                        return false;
                    }
                }
                if(addrProvince == "10"){
                    toast(1000,"请选择收货地区");
                    return false;
                }
                if(addrDetails == "" || addrDetails == ""){
                    toast(1000,"详细地址不能为空");
                    return false;
                }
//		        if(addrZip!=""){
//		        	var zipReg = new RegExp(/^\d{6}$/);
//			        if(zipReg.test(addrZip) == false){
//			        	toast(1000,"邮编必须为6位数字");
//			            return false;
//			        }
//		        }
                if($_this.hasClass('btn_address_save')){
                    //如果需要填写身份证
                    if($("#yourIdCard") && $("#yourIdCard").length>0){
                        if(idCard==""){
                            toast(1000,"身份证号码不能为空");
                            return false;
                        }
                        var idcardValid=identityCodeValidi(idCard);
                        if(!idcardValid.result){
                            toast(1000,"身份证号核验未通过，请重新输入");
                            return false;
                        }
                    }
                }
                if($_this.hasClass('btn_toast_address_save')){
                    //弹出框如果需要填写身份证
                    if($("#toastIdCard") && $("#toastIdCard").length>0){
                        if(idCard==""){
                            toast(1000,"身份证号码不能为空");
                            return false;
                        }
                        var idcardValid=identityCodeValidi(idCard);
                        if(!idcardValid.result){
                            toast(1000,"身份证号核验未通过，请重新输入");
                            return false;
                        }
                    }
                }
                $_this.attr("disabled","true");
                $_this.html("保存中...");
                /*ajax 保存 请求参数 ,提取 用于 encodeRUI  方便 处理 中文乱码*/
                var paramter='addrName='+addrName+"&addrDetails="+addrDetails;
                if($_this.hasClass('btn_address_save')){
                    var isDefaultChecked=$("[id='setaddressInfo.defaultAddr']")[0].checked==true?true:false
                }
                if($_this.hasClass('btn_toast_address_save')){
                    var isDefaultChecked=$("[id='toastDefaultAddr']")[0].checked==true?true:false
                }
                /*ajax 请求参数*/
                var datas= {
                    addrPhone:addrPhone,
                    addressId:addrId,
                    addrProvince:addrProvince,
                    addrCity:addrCity,
                    addrArea:addrArea,
                    district:district,
                    isDefault:isDefaultChecked,
                    idCard:idCard,
                    address:addrDetails
                };
                ajaxUpdateAddress(paramter,datas);
            });
            //设置默认地址
            $("#yourAddrlist").on('click', '.setdefault', function(event) {
                var pointer= $(this).parent().parent().siblings(".addritem").attr("data-pointer");
                var data=addressFunc.tempAddresses[parseInt(pointer)];
                var paramter='addrName='+data.name+"&addrDetails="+data.address;
                var datas= {
                    addrPhone		:data.phone,								//电话
                    addrProvince	:data.cityCode.toString().substring(0,2),			// 省/直辖市 / code
                    addrCity		:data.cityCode.toString().substring(2,4),					// 城/市 代码
                    addrArea		:data.cityCode.toString().substring(4),				// 县 /区 代码
                    isDefault		:true,
                    district		:data.address,
                    addressId		:data.customerAddressId,
                    address			:data.address
                };
                ajaxUpdateAddress(paramter,datas,"setDefault");				//ajax 请求 更新
            });
            var ajaxUpdateAddress=function(paramter,datas,actionType){
                var newAddr = {
                    address: datas.address,
                    cardNo: datas.idCard,
                    cityCode: datas.addrProvince.toString()+datas.addrCity.toString()+datas.addrArea.toString(),
                    customerAddressId: datas.addressId,
                    isDefault: datas.isDefault,
                    name:  $('#toastAddrwrap:hidden').length>0?$.trim($("#yourAddrName").val()):$.trim($("#toastAddrName").val()),
                    phone: datas.addrPhone
                };
                var subUrl=ctx+'/address/saveAddress.do';
                // 处理中文乱码
                if(paramter){
                    subUrl+="?"+paramter;
                    subUrl=encodeURI((encodeURI(subUrl)));
                }
                $.ajax({
                    url: subUrl,
                    type: "POST",
                    data:newAddr,
                    success: function(datajson) {
                        if(datajson.code==0){
                            if(actionType=="setDefault"){//设置默认
                                toast(1000,"默认地址设置成功");
                                $(".check_default").html('<input class="setdefault" type="checkbox">设为默认地址');
                                $(".addritem[id='"+datas.addressId+"']").parent().find(".check_default").html("<span></span>默认地址")
                            }else{//编辑或者新增
                                toast(1000,"地址设置成功");
                                $(".btn_address_save,.btn_toast_address_save").removeAttr("disabled");
                                $(".btn_address_save,.btn_toast_address_save").html("保存并使用");
                                $("#editAddress").hide();
                                $("#toastAddrwrap").hide();
                                if(datas.addressId){ //编辑状态
                                    //addrManageFunc.tempAddresses.push(datajson.result);//回调的 更新之后的 所有地址列表数据
                                    for(var i=0;i<addressFunc.tempAddresses.length;i++){
                                        if(datas.addressId == addressFunc.tempAddresses[i].customerAddressId){
                                            newAddr.createTime = addressFunc.tempAddresses[i].createTime;
                                            addressFunc.tempAddresses.splice(i,1);
                                        }
                                    }
                                    if(datas.isDefault == "true"||datas.isDefault == true){
                                        for(var i=0;i<addressFunc.tempAddresses.length;i++){
                                            addressFunc.tempAddresses[i].isDefault = "false";
                                        }
                                    }
                                    addressFunc.tempAddresses.push(newAddr);
                                    WX.orderAjaxDatas.addressInfo = addressFunc.tempAddresses;
                                }else{
                                    if(datas.isDefault == "true"||datas.isDefault == true){
                                        if(addressFunc.tempAddresses){
                                            for(var i=0;i<addressFunc.tempAddresses.length;i++){
                                                addressFunc.tempAddresses[i].isDefault = "false";
                                            }
                                        }

                                    }
                                    if(addressFunc.tempAddresses){
                                        addressFunc.tempAddresses.push(datajson.result);//回调的 更新之后的 所有地址列表数据
                                    }else{
                                        addressFunc.tempAddresses = [datajson.result];
                                    }

                                }
                                $("#yourAddrlist").html("");//清空地址列表
                                WX.orderAjaxDatas.addressInfo = addressFunc.tempAddresses;
                                WX.orderAjaxDatas.setAddressReach();
                                for(var i=0;i<WX.orderAjaxDatas.addressInfo.length;i++){//根据数据从新更新地址列表
                                    addAddress(WX.orderAjaxDatas.addressInfo[i],i);
                                }
                                $("#yourAddrlist").append('<button class="btn-orange btn_new_address">添加新地址</button>');

                                if(datas.addressId){//如果是编辑地址
                                    addressFunc.selectAddress=getAddrId(datas.addressId)
                                    $("#yourAddrlist .ditem").removeClass("selected");
                                    $(".addritem[id='"+datas.addressId+"']").parent().addClass("selected");
                                }else{//新增地址
                                    addressFunc.selectAddress=addressFunc.tempAddresses[addressFunc.tempAddresses.length-1];//设置选中的地址为新增的地址。即列表中的最后一个
                                    $("#yourAddrlist .ditem").removeClass("selected");
                                    $("#yourAddrlist .ditem").eq(0).addClass("selected");//第一个地址增加select样式。展示的列表顺序和数据顺序是相反的
                                }
                                window.location.hash="";
                                $(".order_buy").show();
                                addressFunc.setAddress();
                                if(addressFunc.tempAddresses.length>=5){
                                    $("#yourAddrlist .btn_new_address").hide();
                                }
                                //新增地址完成之后 ,从新初始化初始化
                                $("#yourAddrName").val("");
                                $("#yourAddrPhone").val("");
                                $("#yourAddrProvince").val("10");
                                $("#yourAddrProvince").change();
                                $(".addr_group").hide();
                                $("#yourAddrDetails").val("");
//			    	     	    $("#yourAddrZip").val("");
                                $("#yourIdCard").val("");
                                $("#yourAddr").val("");
                                var productAjaxParams="";
                                $.each(WX.orderAjaxDatas.productJson.productItems,function(index,obj){
                                    productAjaxParams+="&activity_id="+obj.activity.goodsId;
                                    productAjaxParams+="&activity_spec="+obj.productSpecs;
                                    productAjaxParams+="&activity_count="+obj.payCount;
                                    productAjaxParams+="&logisticsTemplateId="+(WX.orderAjaxDatas.postType == 1 ? obj.activity.logisticsTemplateId : obj.activity.takeOutLogisticsTemplateId);
                                })
                                $.ajax({
                                    url:ctx+"/order/ajaxMain.do?methodName=freightSupport&"+productAjaxParams,
                                    type:"post",
                                    data:{"addressId":addressFunc.selectAddress.customerAddressId},
                                    success:function(data){
                                        if(data.support==-2){
                                            WX.onSupport=true;
                                            $("#freightAmout").data("hint","该商户未设置物流").removeClass('select-delivery-time');
                                            $("#freightAmout").text("该商户未设置物流");
                                        }else if(data.support==-1){
                                            WX.onSupport=true;
                                            $("#freightAmout").data("hint","您所选择的区域暂不支持配送").removeClass('select-delivery-time');
                                            $("#freightAmout").text("不支持配送");
                                            WX.onSupportProName=data.message;
                                        }else{
                                            WX.onSupport=false;
                                        }
                                        addressFunc.calculatePayAmount();
                                    }
                                });
                            }
                        }else{
                            toast(1000,"更新地址失败,请刷新页面,稍后重试!");
                            $(".btn_address_save,.btn_toast_address_save").removeAttr("disabled");
                            $(".btn_address_save,.btn_toast_address_save").html("保存并使用");
                        }
                    },
                    error: function() {
                        toast(1000,"更新地址失败,请刷新页面,稍后重试!");
                        $(".btn_address_save,.btn_toast_address_save").removeAttr("disabled");
                        $(".btn_address_save,.btn_toast_address_save").html("保存并使用");
                    }
                });
            };
            /*选择显示城市列表*/
            $(".addr_area").on('click',function(e){
                if($(".addr_group").is(":hidden")){
                    $("#yourAddr").css("border-bottom-width","0");
                }else{
                    $("#yourAddr").css("border-bottom-width","1px");
                }
                $(".input.your_addr").find(".addr_group").slideToggle();
                var _province=$("#yourAddrProvince").find("option:selected").text();
                var _city=$("#yourAddrCity").find("option:selected").text();
                var _area=$("#yourAddrArea").find("option:selected").text();
                var _val=$("#yourAddrProvince").find("option:selected").val();
                if(_val === '10'){
                    $(".input.your_addr").find("input").val('请选择');
                }else{
                    $(".input.your_addr").find("input").val(_province+_city+_area);
                }
            });
            /*弹出框选择显示城市列表*/
            $(".toast_area").on('click',function(e){
                if($(".toast_group").is(":hidden")){
                    $("#toastAddr").css("border-bottom-width","0");
                }else{
                    $("#toastAddr").css("border-bottom-width","1px");
                }
                $(".input.toast_addr").find(".toast_group").slideToggle();
                //var addrFull = $("#toastAddrProvince").find("option:selected").text()+$("#toastAddrCity").find("option:selected").text()+$("#toastAddrArea").find("option:selected").text();
                //$(".input.toast_addr").find("input").val(addrFull);
                var _province=$("#toastAddrProvince").find("option:selected").text();
                var _city=$("#toastAddrCity").find("option:selected").text();
                var _area=$("#toastAddrArea").find("option:selected").text();
                var _val=$("#toastAddrProvince").find("option:selected").val();
                if(_val === '10'){
                    $(".input.toast_addr").find("input").val('请选择');
                }else{
                    $(".input.toast_addr").find("input").val(_province+_city+_area);
                }
            });
            //根据选择的城市拼出地址
            $(".addr_group select").change(function(){
                $("#yourAddr").val(cityUtils.getAddr($("#yourAddrProvince").val()+$("#yourAddrCity").val()+$("#yourAddrArea").val()));
            });
            //弹出框根据选择的城市拼出地址
            $(".toast_group select").change(function(){
                $("#toastAddr").val(cityUtils.getAddr($("#toastAddrProvince").val()+$("#toastAddrCity").val()+$("#toastAddrArea").val()));
            });
            //编辑地址
            $("#address_div").on('click',".editaddr",function(event){
                event.preventDefault();
                $('[id="setaddressInfo.defaultAddr"]').prop("checked",false);
                var $_this = $(this);
                var addrId = $_this.attr("data-id");
                var cur_addr = getAddrId(addrId);
                var options={
                    province	:'yourAddrProvince',			//	省/直辖市
                    city		:'yourAddrCity',			//	市
                    county		:'yourAddrArea',			//	县/区
                    defaultCitys:cur_addr.cityCode.toString().slice(0,2)+"|"+cur_addr.cityCode.toString().slice(2,4)+"|"+cur_addr.cityCode.toString().slice(4,6),			//	默认城市 代码
                };
                cityUtils.init(options);
                $("#createAddrwrap").attr("data-id",addrId);
                $("#yourAddrName").val(cur_addr.name);
                $("#yourAddrPhone").val(cur_addr.phone);
                $("#yourIdCard").val(cur_addr.cardNo);
//		    	 $("#yourAddrZip").val(cur_addr.zipcode);
                $("#yourAddr").val(cityUtils.getAddr(cur_addr.cityCode));
                $("#yourAddrDetails").val(cur_addr.address);
                if(cur_addr.isDefault==1){
                    $('[id="setaddressInfo.defaultAddr"]').prop("checked",true);
                }else {
                    $('[id="setaddressInfo.defaultAddr"]').prop("checked",false);
                }
                $("#yourAddrlist").hide();
                $("#editAddress").show();
                $(window).scrollTop(0);
                window.location.hash="editAddress";
            });
            //根据地址id获取地址信息
            function getAddrId(id){
                for(var i = 0;i<addressFunc.tempAddresses.length;i++){
                    if(addressFunc.tempAddresses[i]){
                        if(addressFunc.tempAddresses[i].customerAddressId == id){
                            return addressFunc.tempAddresses[i];
                        }
                    }
                }
            }
            /*删除地址事件*/
            $("#yourAddrlist").on('click', '.deladdr', function(event) {
                event.preventDefault();
                var div=$(this).parent().parent();//获取 当前操作 地址的 div 标签
                var addrId = $(this).parent().siblings(".addritem").attr("id");	//获取 要删除的地址的ID
                var pointer= $(this).parent().siblings(".addritem").attr("data-pointer");	//获取 当前地址对应 数据信息 在 addresses 数据 数组内的 指针
                $.ajax({
                    url: ctx+'/address/deleteAddress.do',
                    type: "POST",
                    datatype:"json",
                    data: {addressId:addrId},
                    success: function(data) {
                        if(data.code==0){
                            addressFunc.tempAddresses.splice(parseInt(pointer),1);//删除地址数据
                            div.remove();//删除当前 地址 div 标签
                            toast(1000,"删除成功");
                            if($("#yourAddrlist .ditem").length<5){//显示新增按钮
                                $("#yourAddrlist .btn_new_address").show();
                            }
                            if($("#yourAddrlist .ditem").length==0){
                                $("#yourAddrlist").hide();
                                $("#emptyAddress").show();
                            }
                        }else{
                            toast(1000,"删除失败,请刷新页面,重试!");
                        }
                    },
                    error: function() {
                        toast(1000,"删除失败,请刷新页面,重试!");
                    }

                });
            });
            /*地址 选中 事件*/
            $("#yourAddrlist").on('click',".addritem", function() {
                if($(this).parent('.ditem').hasClass('disabled')){
                    return false;
                }
                var $this = $(this);
                var pointer=$this.data("pointer");		//获取 当前 地址 在 地址数据 数组内的 指针
                $this.parent().addClass('selected');					//设置样式
                $this.parent().siblings().removeClass('selected');
                window.location.hash="";
                $(".order_buy").show();
                $("#yourAddrlist").hide();
                addressFunc.selectAddress=addressFunc.tempAddresses[parseInt(pointer)];//设置 选中的地址
                addressFunc.setAddress();
                var productAjaxParams="";
                $.each(WX.orderAjaxDatas.productJson.productItems,function(index,obj){
                    productAjaxParams+="&activity_id="+obj.activity.goodsId;
                    productAjaxParams+="&activity_spec="+obj.productSpecs;
                    productAjaxParams+="&activity_count="+obj.payCount;
                    productAjaxParams+="&logisticsTemplateId=" + (WX.orderAjaxDatas.postType == 1 ? obj.activity.logisticsTemplateId : obj.activity.takeOutLogisticsTemplateId);
                })
                $.ajax({
                    url:ctx+"/order/ajaxMain.do?methodName=freightSupport&"+productAjaxParams,
                    type:"post",
                    data:{"addressId":addressFunc.selectAddress.customerAddressId},
                    success:function(data){
                        if(data.support==-2){
                            WX.onSupport=true;
                            $("#freightAmout").data("hint","该商户未设置物流").removeClass('select-delivery-time');
                            $("#freightAmout").text("该商户未设置物流");
                        }else if(data.support==-1){
                            WX.onSupport=true;
                            $("#freightAmout").data("hint","您所选择的区域暂不支持配送").removeClass('select-delivery-time');
                            $("#freightAmout").text("不支持配送");
                            WX.onSupportProName=data.message;
                        }else{
                            WX.onSupport=false;
                        }
                        addressFunc.calculatePayAmount();
                    }
                });
            });
        },
        //设置地址
        setAddress:function (){
            if(addressFunc.selectAddress.customerAddressId){//设置头部的地址信息
                if (WX.orderAjaxDatas.postType == '1') {
                    addressFunc.tempDeliveryAddress = $.extend({}, addressFunc.selectAddress);
                } else if (WX.orderAjaxDatas.postType == '3') {
                    addressFunc.tempTakeoutAddress = $.extend({}, addressFunc.selectAddress);
                }

                var addDetail = cityUtils.getAddr(addressFunc.selectAddress.cityCode);
                $('.top_info .address-content').removeClass('no-address');
                $('.top_info .address-name').text(addressFunc.selectAddress.name);
                $('.top_info .address-phone').text(addressFunc.selectAddress.phone);
                $('.top_info .address-home').text(addDetail + ' ' + addressFunc.selectAddress.address);
                $("#addressId").val(addressFunc.selectAddress.customerAddressId);
                $("#addrPhone").val(addressFunc.selectAddress.phone);
                if($('#logintype').val()==='2'){//未登录状态
                    $('.phone-input-div .input-tips').html('请完善您的手机号验证后完成下单；若您填写的收货人手机号非本人号码，请点击修改')
                    $('.phone-input-div').show();
                    $('.phone-input-div .phone-item input').val(addressFunc.selectAddress.phone);
                }
                if($('#logintype').val()==='1'){//微信自动登录，未绑定手机号
                    $('.phone-input-div .input-tips').html('当前为微信账号登录，请完善您的手机号验证后完成下单；若您填写的收货人手机号非本人号码，请点击修改')
                    $('.phone-input-div').show();
                    $('.phone-input-div .phone-item input').val(addressFunc.selectAddress.phone);
                }

                if (WX.orderAjaxDatas.postType == '3') {
                    $('.takeout-distance-info').show();
                    $.ajax({
                        url: ctx + '/address/getStoreDistance.do',
                        type: 'post',
                        data: {
                            addressId: addressFunc.selectAddress.customerAddressId
                        },
                        success: function (res) {
                            if (res.code == 1) {
                                $('#takeoutDistance').html('距您<span class="text-red">'+res.data+'</span>公里');
                            } else {
                                $('#takeoutDistance').html('超出外卖配送范围');
                            }
                        }
                    })
                } else {
                    $('.takeout-distance-info').hide();
                }
            }
        },
        //计算费用
        calculatePayAmount:function(){
            $(".bot_buttons.buy .btn-red").attr("disabled",true);
            var addressId=addressFunc.selectAddress.customerAddressId;//地址id
            var exchangeCredits=$("#exchangeCredits").val();//是否使用积分
            var params="";//商品id、skuid、数量
            $.each(WX.orderAjaxDatas.productJson.productItems,function(index,obj){
                params+="&activity_id="+obj.activity.goodsId;
                params+="&activity_spec="+obj.productSpecs;
                params+="&activity_count="+obj.payCount;
            });
            $.ajax({
                url:ctx+"/order/ajaxMain.do?methodName=calculatePayAmount"+params+"&orderType="+WX.orderAjaxDatas.orderType+"&giftNum="+WX.orderAjaxDatas.giftNum,
                type:"post",
                data:{
                    "addressId":addressId,
                    "exchangeCredits":exchangeCredits,
                    "couponCode":$("#submitCouponCode").val(),
                    "couponId":$("#submitCouponId").val(),
                    "postType":WX.orderAjaxDatas.postType,
                    "feeType": $('[name=discountWay]:checked').val() //1优惠券2积分3营销方案
                },
                success:function(data){
                    $(".bot_buttons.buy .btn-red").removeAttr("disabled");
                    if(data.result==1){//成功
                        //-1 无效优惠码,-2:已过期,-3已使用,-4:满减限制,-5:导航限制,-6:活动限制
                        /*if(data.couponCodeStatus==-1||data.couponCodeStatus==-4||data.couponCodeStatus==-5||data.couponCodeStatus==-6){
                            toast(1000,"无效优惠码")
                        }
                        if(data.couponCodeStatus==-2){
                            toast(1000,"优惠码已过期")
                        }
                        if(data.couponCodeStatus==-3){
                            toast(1000,"优惠码已使用")
                        }*/

                        // 显示封顶优惠金额
                        if(parseFloat(data.feeBalanceAmountRate) > 0){
                            $('#useCouponTips').html('*订单优惠封顶为'+data.feeBalanceAmountRate+'元')
                        }else{
                            $('#useCouponTips').html('')
                        }
                        if(data.codeStatus==0){
                            toast(1000,data.message);
                        }
                        var amount = data.sumPaidFee;//合计金额
                        var areaFee = data.freightPaid;//邮费
                        window.totalPrice = (amount/100).toFixed(2)
                        $('#pro_total_price,#detail_pro_total_price').text(((amount-areaFee)/100).toFixed(2));
                        $("#dataMoney").text((amount/100).toFixed(2));
                        $("#freightAmout").removeClass('toAddAddress').removeClass('select-delivery-time').removeAttr('data-date').removeAttr('data-start').removeAttr('data-end');
                        if((WX.orderAjaxDatas.orderType == 1 || WX.orderAjaxDatas.orderType == 4) && WX.orderAjaxDatas.postType == 2){
                            $("#freightAmout").text("");
                        }else{
                            if(WX.orderAjaxDatas.orderType==3){//送朋友
                                if(areaFee==0){//邮费为0，包邮
                                    $("#freightAmout").text("包邮");
                                    if((WX.orderAjaxDatas.supportDeliveryTime && WX.orderAjaxDatas.postType == 1) || (WX.orderAjaxDatas.supportTakeoutTime && WX.orderAjaxDatas.postType == 3)){
                                        $("#freightAmout").addClass('select-delivery-time').html('包邮 | 请选择您期望配送时间');
                                    }
                                }else{
                                    $("#freightAmout").html("运费&yen;"+(areaFee/100).toFixed(2));
                                    if((WX.orderAjaxDatas.supportDeliveryTime && WX.orderAjaxDatas.postType == 1) || (WX.orderAjaxDatas.supportTakeoutTime && WX.orderAjaxDatas.postType == 3)){
                                        $("#freightAmout").addClass('select-delivery-time').html('运费&yen;'+(areaFee/100).toFixed(2)+' | <span>请选择您期望配送时间</spam>');
                                    }
                                }
                            }else{
                                if(addressFunc.selectAddress.customerAddressId){//有地址
                                    if(WX.onSupport==true){

                                    }else{
                                        if(areaFee==0){//邮费为0，包邮
                                            $("#freightAmout").text("包邮");
                                            if((WX.orderAjaxDatas.supportDeliveryTime && WX.orderAjaxDatas.postType == 1) || (WX.orderAjaxDatas.supportTakeoutTime && WX.orderAjaxDatas.postType == 3)){
                                                $("#freightAmout").addClass('select-delivery-time').html('包邮 | <span>请选择您期望配送时间</spam>');
                                            }
                                        }else{
                                            $("#freightAmout").html("运费&yen;"+(areaFee/100).toFixed(2));
                                            if((WX.orderAjaxDatas.supportDeliveryTime && WX.orderAjaxDatas.postType == 1) || (WX.orderAjaxDatas.supportTakeoutTime && WX.orderAjaxDatas.postType == 3)){
                                                $("#freightAmout").addClass('select-delivery-time').html('运费&yen;'+(areaFee/100).toFixed(2)+' | <span>请选择您期望配送时间</spam>');
                                            }
                                        }
                                    }
                                }else{//没有地址
                                    $("#freightAmout").addClass('toAddAddress').text("请填写收货地址");
                                }
                            }
                        }
                        // 余额支付显示，goodDiscountFee > 0时有余额支付优惠
                        if($('#logintype').val() == 3 && $('.online-pay-item .pay-icon.balance-pay').parents('.choose-item').is(':visible')){
                            if (data.goodDiscountFee > 0) {
                                $('.balance-discount').show();
                                $('#balanceDiscountValue').text((data.goodDiscountFee / 100).toFixed(2));
                                window.balanceDiscountPrice = ((amount - data.goodDiscountFee) / 100).toFixed(2);
                                if ($('.online-pay-item .pay-icon.balance-pay').prop('checked')){
                                    $("#dataMoney").text(balanceDiscountPrice);           
                                }
                            }
                            var balanceMoney = parseFloat($('.balance-pay').attr('data-balance')),
                                storeCardType = parseFloat($('.balance-pay').attr('data-type')),
                                itemInfo = '';
                            if(amount > parseInt(balanceMoney * 100)){ // 余额不足
                                if(storeCardType == '1'){  //舞象储值
                                    itemInfo = '<a href="'+ctx+'/storeDeposit/main.do?methodName=prePaidCodeSetList&storeid='+WX.storeid+'&salesid="><span class="text-red">'+balanceMoney+unit+'，余额不足，请充值</span></a>';
                                }else if(storeCardType == '2'){  //第三方储值
                                    itemInfo = '<span class="text-red">'+balanceMoney+unit+'，余额不足，请充值</span>';
                                }
                                $('.balance-pay').attr('data-allow', 'false');
                            }else{
                                itemInfo = '<span class="text-red">'+balanceMoney+unit+'</span>';
                                $('.balance-pay').attr('data-allow', 'true');
                            }
                            $('.online-pay-item .pay-icon.balance-pay').parents('.choose-item').find('.item-info').html(itemInfo);
                        }
                    }
                },
                error:function(){
                    $(".bot_buttons.buy .btn-red").removeAttr("disabled");
                }
            });
        }
    };
    module.exports=addressFunc;
});
