define(function (require, exports, module) {
    var $ = require('jquery');
    var toast = require('toast');
    var activity = {};
    function getSkuid(){//获取当前选中规格的skuid
        var skuId = [],
            specText = [];
        $(".pro_size.active").each(function(index,obj){
            skuId.push($(obj).attr("data-id"));
            specText.push($(obj).parents('.mid_info').find('.skus_name').text() + '：' + $(obj).text())
        });
        skuId=skuId.sort(sortNumber).join(",");
        $.each(activity.goodsBean.skuList,function(index,obj){
            if(obj.specValue.split(",").sort(sortNumber).join(",")==skuId)
                skuId=obj;
        })
        return {
            sku: skuId,
            specText: specText
        };
    }
    function init_sku() {
        //验证每一个不为active的sku按钮是否可点
        $(".choose_pro .pro_size").each(function(index,obj){
            if(!$(obj).hasClass("active")){//每一个不为active的sku按钮
                var cur_val_skus=[];//当前sku按钮需要验证的skuID数组，如[[1,2,3],[5],[7,8,9]]
                var cur_val_sku=[];
                var pointer_index=parseInt($(obj).parent().attr("data-pointer"));//这个规格是属于第几行规格组的
                cur_val_sku.push(parseInt($(obj).attr("data-id")));
                cur_val_skus[pointer_index]=cur_val_sku;//把这个规格放到对应的验证数据位置
                $(".choose_pro .mid_info").each(function(mid_info_index,mid_info_obj){
                    if(mid_info_index!=pointer_index){//遍历不属于这个规格同一行的规格
                        cur_val_sku=[];
                        if($(mid_info_obj).find(".pro_size.active").length>0){//如果这一行有选中的规格
                            cur_val_sku.push(parseInt($(mid_info_obj).find(".pro_size.active").attr("data-id")));
                        }else{//如果这一行没有选中规格
                            $(mid_info_obj).find(".pro_size").each(function(pro_size_index,pro_size_obj){
                                cur_val_sku.push(parseInt($(pro_size_obj).attr("data-id")));
                            });
                        }
                        cur_val_skus[mid_info_index]=cur_val_sku;
                    }
                });
                function checkSkuMount(check_sku){//匹配一个sku值对应的库存数方法
                    var check_sku_mout = 0,
                        check_sku_code = '';
                    $.each(activity.goodsBean.skuList,function(sku_index,sku_obj){//遍历数据中的sku
                        var sku_obj_specValue=","+sku_obj.specValue.split(",").sort(sortNumber).join(",")+",";
                        if(sku_obj_specValue==check_sku){
                            check_sku_mout+=sku_obj.stock;//增加库存数
                            check_sku_code=sku_obj.skuCode;
                            return false;
                        }
                    });
                    return {
                        check_sku_mout: check_sku_mout,
                        check_sku_code: check_sku_code
                    };
                }
                //验证cur_val_skus组合出来的规格是否有库存
                if(cur_val_skus.length==1){//一种规格
                    var check_sku_mout = 0,
                        hasSkuCode = false;
                    for(var i=0;i<cur_val_skus[0].length;i++){
                        var check_sku=","+cur_val_skus[0][i]+",";
                        var tempSkuObj = checkSkuMount(check_sku);
                        check_sku_mout+=tempSkuObj.check_sku_mout;
                        if (tempSkuObj.check_sku_code) {
                            hasSkuCode = true;
                        }
                    }
                    if(check_sku_mout==0)
                        $(obj).addClass("disable");
                    else
                        $(obj).removeClass("disable")
                    if (hasSkuCode) {
                        $(obj).show();
                    } else {
                        $(obj).hide();
                    }
                }
                if(cur_val_skus.length==2){//二种规格
                    var check_sku_mout = 0,
                        hasSkuCode = false;
                    for(var i=0;i<cur_val_skus[0].length;i++){
                        for(var j=0;j<cur_val_skus[1].length;j++){
                            var check_sku=cur_val_skus[0][i]+","+cur_val_skus[1][j];
                            check_sku=","+check_sku.split(",").sort(sortNumber).join(",")+",";
                            var tempSkuObj = checkSkuMount(check_sku);
                            check_sku_mout+=tempSkuObj.check_sku_mout;
                            if (tempSkuObj.check_sku_code) {
                                hasSkuCode = true;
                            }
                        }
                    }
                    if(check_sku_mout==0)
                        $(obj).addClass("disable");
                    else
                        $(obj).removeClass("disable")
                    if (hasSkuCode) {
                        $(obj).show();
                    } else {
                        $(obj).hide();
                    }
                }
                if(cur_val_skus.length==3){//三种规格
                    var check_sku_mout = 0,
                        hasSkuCode = false;
                    for(var i=0;i<cur_val_skus[0].length;i++){
                        for(var j=0;j<cur_val_skus[1].length;j++){
                            for(var k=0;k<cur_val_skus[2].length;k++){
                                var check_sku=cur_val_skus[0][i]+","+cur_val_skus[1][j]+","+cur_val_skus[2][k];
                                check_sku=","+check_sku.split(",").sort(sortNumber).join(",")+",";
                                var tempSkuObj = checkSkuMount(check_sku);
                                check_sku_mout+=tempSkuObj.check_sku_mout;
                                if (tempSkuObj.check_sku_code) {
                                    hasSkuCode = true;
                                }
                            }
                        }
                    }
                    if(check_sku_mout==0)
                        $(obj).addClass("disable");
                    else
                        $(obj).removeClass("disable")
                    if (hasSkuCode) {
                        $(obj).show();
                    } else {
                        $(obj).hide();
                    }
                }
            }
        })
        /* 根据选中的sku计算规格数和价格并显示规格值 */
        $(".choose_pro .mid_info").each(function(index,obj){
            if($(obj).find(".pro_size.active").length==0){//没有选中sku时显示规格名称
                $(".top_info .text .skus span").eq(parseInt($(obj).find("div").attr("data-pointer"))).html(activity.goodsBean.specList[parseInt($(obj).find("div").attr("data-pointer"))].name)
            }
        });
        if($(".pro_size.active").length>0){
            /* 如果有选中的规格 */
            var active_specValue=[];
            var sku_mount=0;//选中的sku对应的库存总数
            var sku_price=[];//选中的sku对应的库存价格
            //规格未全部选择完时
            if($(".pro_size.active").length==$(".choose_pro .mid_info").length){
                $(".pro_size.active").each(function(index,obj){//全部选完时，显示选中的规格值
                    $(".top_info .text .skus span").eq(parseInt($(obj).parent().attr("data-pointer"))).html($(obj).html()).show();
                    active_specValue.push(","+$(obj).attr("data-id")+",");
                })
                $('.top_info .text .skus .skus-title').html('规格：');
            }else{
                $(".pro_size.active").each(function(index,obj){//未全部选完时，隐藏选中的规格值
                    $(".top_info .text .skus span").eq(parseInt($(obj).parent().attr("data-pointer"))).html($(obj).html()).hide();
                    active_specValue.push(","+$(obj).attr("data-id")+",");
                })
                $('.top_info .text .skus .skus-title').html('请选择：');
            }
            $.each(activity.goodsBean.skuList,function(sku_index,sku_obj){//遍历数据中的sku
                var sku_obj_specValue=","+sku_obj.specValue+",";
                var contain_sku_flag=true;//是否包含选中SKU
                //获取所有包含选中SKU的specValue
                $.each(active_specValue,function(active_index,active_obj){
                    if(sku_obj_specValue.indexOf(active_obj)==-1){
                        contain_sku_flag=false;
                        return false;
                    }
                })
                if(contain_sku_flag){//如果specValue包含所有选中的sku
                    if(sku_obj.picUrl){ // 多规格主图切换
                        $('.top_info .img img').attr('src', activity.imageDomain + sku_obj.picUrl)
                    }else{
                        $('.top_info .img img').attr('src', activity.imageDomain + activity.goodsBean.indexUrls[1])
                    }
                    sku_mount+=sku_obj.stock;//增加库存数
                    if (sku_obj.salesPrice > 0) {
                        sku_price.push(sku_obj.salesPrice)//所有匹配到的组合的价格
                    }
                }
            });
            //计算最大价格和最小价格
            sku_price=sku_price.sort(sortNumber);//从小到大排序
            var min_sku_price=(sku_price[0]/100).toFixed(2);
            var max_sku_price=(sku_price[sku_price.length-1]/100).toFixed(2);
            if(min_sku_price==max_sku_price)
                sku_price="&yen"+min_sku_price
            else
                sku_price="&yen"+min_sku_price+"&nbsp;&nbsp;~&nbsp;&nbsp;"+"&yen"+max_sku_price;
            $(".choose_pro .top_info .store span").html(sku_mount);//显示库存数
            $(".choose_pro .top_info .price span").html(sku_price)//显示价格
        }else{
            $(".choose_pro .top_info .store span").html(activity.goodsBean.totalStock);//显示库存数
            var priceText="";
            if(activity.goodsBean.minSalesPrice!=activity.goodsBean.maxSalesPrice)
                priceText= '&yen;'+(activity.goodsBean.minSalesPrice/100).toFixed(2)+'&nbsp;~&nbsp;&yen;'+(activity.goodsBean.maxSalesPrice/100).toFixed(2);
            if(activity.min_sku_price==activity.max_sku_price)
                priceText='&yen;'+(activity.goodsBean.minSalesPrice/100).toFixed(2);
            $(".choose_pro .top_info .price span").html(priceText)//显示价格
            $('.top_info .text .skus .skus-title').html('请选择：');
        }
        $(".sku").css("max-height",451-$(".top_info").height()-$(".bot_button").height()-30+"px");//设置规格选择区域的高度
    }
    function sortNumber(a,b){//从小到大排序方法
        return a - b
    }
    module.exports = {
        hideSkus: function () {
            $('.choose_pro').toggleClass("pro_ease");
            $('.mask').fadeOut(200);
        },
        showSkus: function (config, callback) { // 传参商品数据和选择商品回调
            $(function () {
                $(".choose_pro").remove();
                $.ajax({
                    url: ctx + '/activity/ajaxMain.do?methodName=getActivityById&id=' + config.productId,
                    success: function (data) {
                        activity = data;
                        var div =
                            '<div class="choose_pro">' +
                                '<div>' +
                                    '<div class="close_buy"></div>' +
                                    '<div class="top_info">' +
                                        '<div class="img">' +
                                            '<img src="'+data.imageDomain+data.goodsBean.indexUrls[1]+'" />' +
                                        '</div>' +
                                        '<div class="text">' +
                                            '<p class="price">';
                        if(data.goodsBean.minSalesPrice!=data.goodsBean.maxSalesPrice)
                            div += '<span>&yen;' + (data.goodsBean.minSalesPrice / 100).toFixed(2) + '&nbsp;~&nbsp;&yen;' + (data.goodsBean.maxSalesPrice / 100).toFixed(2) + '</span>';
                        else
                            div += '<span>&yen;' + (data.goodsBean.minSalesPrice / 100).toFixed(2) + '</span>';
                        div +=
                                            '</p>' +
                                            '<p class="text-grey-light store">库存：<span>' + data.goodsBean.totalStock + '</span></p>' +
                                            '<p class="text-grey-light skus"><label class="skus-title">请选择：</label>';
                        for(var i = 0; i<data.goodsBean.specList.length;i++){
                            div += '<span>'+data.goodsBean.specList[i].name+'</span>&nbsp;';
                        }
                        div +=
                                        '</div>' +
                                        '<div style="clear:both"></div>' +
                                    '</div>' +
                                    '<div class="sku">';
                        for(var j=0;j<data.goodsBean.specList.length;j++){
                            div +=
                                        '<div class="mid_info">' +
                                            '<p class="skus_name">' + data.goodsBean.specList[j].name + '</p>' +
                                            '<div data-pointer="' + j + '">';
                            for(var k=0;k<data.goodsBean.specList[j].specValueList.length;k++){
                                div += '<a data-id="'+data.goodsBean.specList[j].specValueList[k].id+'" class="pro_size btn">'+data.goodsBean.specList[j].specValueList[k].name+'</a>';
                            }
                            div +=
                                            '</div>' +
                                        '</div>';
                        }
                        div +=
                                        '<div class="bot_info"' + (config.staticNum ? 'style="display: none"' : '') + '>' +
                                            '<p>数量</p>' +
                                            '<div>' +
                                                '<button class="redus">&minus;</button>' +
                                                '<input type="tel" id="quantity" data-inputtype="number" value="' + (config.staticNum ? config.staticNum : 1) + '"/>' +
                                                '<button class="add">&plus;</button>' +
                                            '</div>' +
                                        '</div>';
                        div +=
                                    '</div>' +
                                    '<div class="bot_button">' +
                                        '<button class="btn-red" id="confirmSkuSelect"><span>确定</span><img src="' + resourcePath + '/img/loading.gif"/></button>' +
                                    '</div>' +
                                '</div>'+
                            '</div>';
                        $("body").append(div);
                        $(".mask").fadeIn(300);
                        $(".choose_pro").toggleClass("pro_ease");
                        // 查看規格大圖
                        $('.choose_pro').on('click', '.top_info .img img', function(){
                            $('.sku-image-preview img').attr('src', $(this).attr('src').slice(0, $(this).attr('src').length - 12) + '_512_512.jpg');
                            $('.sku-image-preview').fadeIn();
                        })
                        $('.sku-image-preview').click(function(){
                            $('.sku-image-preview').fadeOut();
                        })
                        //点击一个规格
                        $('.mid_info a').on('click',function() {
                            if (!$(this).hasClass("disable")) {
                                if(!$(this).hasClass("active")){
                                    $(this).siblings('a').removeClass("active");
                                    $(this).addClass("active");
                                }else{
                                    $(this).removeClass("active")
                                }
                                init_sku();
                            }
                        });
                        init_sku();
                        $('.mask, .close_buy').on('click', function() {//关闭选择规则弹出框
                            $('.choose_pro').removeClass("pro_ease");
                            $('.mask').fadeOut(200);
                            $('.buy_mask').hide();
                            $('.send_mask').hide();
                        });
                        $('#quantity').on('keyup',function() {//输入数量
                            if($(this).val()=="")
                                $(this).val(1);
                            if (parseInt($(this).val()) < 0)
                                $(this).val(1);
                            if (parseInt($(this).val()) > parseInt($.trim($(".top_info .text .store span").html()))) {
                                $(this).val($.trim($(".top_info .text .store span").html()));
                                toast(1000, "超过购买限制");
                            }
                            if (activity.goodsBean.quantityAverage != 0) {
                                if (parseInt($(this).val()) > activity.goodsBean.quantityAverage) {
                                    $(this).val(activity.goodsBean.quantityAverage);
                                    toast(1000, "每人限购" + activity.goodsBean.quantityAverage + "件");
                                }
                            }
                        });
                        $('.redus').on('click', function() {//点击减少数量按钮
                            if (parseInt($(this).next().val()) > 1)
                                $(this).next().val(parseInt($(this).next().val()) - 1);
                        });
                        $('.add').on('click',function() {//点击增加数量按钮
                            if (parseInt($(this).prev().val()) < parseInt($.trim($(".top_info .text .store span").html()))) {
                                if (activity.goodsBean.quantityAverage == 0) {
                                    $(this).prev().val(parseInt($(this).prev().val()) + 1);
                                } else {
                                    //如果购买数量大于人均限制, 按钮点击不累加
                                    if ($("#quantity").val() < activity.goodsBean.quantityAverage) {
                                        $(this).prev().val(parseInt($(this).prev().val()) + 1);
                                    } else
                                        toast(1000, "每人限购" + activity.goodsBean.quantityAverage+ "件");
                                }
                            } else
                                toast(1000, "超过购买限制");
                        });
                        // 确定选择规格
                        $("#confirmSkuSelect").on("click",function(){
                            var $_this = $(this);
                            var carttype = "1";
                            if(activity.goodsBean.type==0){//普通商品
                                carttype = "1"
                            }else if(activity.goodsBean.type==1){//电子券
                                carttype = "2"
                            }
                            var quantity = $("#quantity").val();
                            if(quantity == 0){
                                toast(1000, "你的购买数量为0,不能提交");
                            }else{
                                if($('.mid_info .active').length < $('.mid_info').length){//没有选择规格
                                    toast(1000, "请选择商品规格");
                                }else{
                                    var skuSelect = getSkuid();
                                    callback.call(this, skuSelect);
                                }
                            }
                        });

                    }
                });
            })
        }
    }
})