define(function (require, exports, module) {
	var wx = require("jweixin");
	var cookieFunc = require("cookies");
	var urlParam = require("urlParam");
	window.wx = wx;
	var func = {
		initfunc: function () {
			window.WX = window.WX || {};
			WX.weixin = {};
			//设置分享 相关的 url 图片url 内容
			WX.weixin.share = {};	//定义分享对象
			WX.weixin = WX.weixin || {};
			WX.weixin.appID = getAppId();
			function getAppId() {
				var appId = 'wx0376eb564b516c7c';
				$.ajax({
					url: ctx + "/weixin-developer/ajaxMain.do?methodName=getAppId",
					async: false,
					success: function (result) {
						appId = result;
					}
				});
				return appId;
			}
			//设置分享 相关的 url 图片url 内容
			WX.weixin.share = WX.weixin.share || {};	//定义分享对象
			WX.weixin.share.resetData = WX.weixin.share.resetData || function () { };//定义 重置接口数据的接口,方便外部重写
			WX.weixin.share.resetInter = WX.weixin.share.resetInter || function () { };
			//获取 签名
			WX.weixin.getSign = function () {
				if (!WX.weixin.sign)
					$.ajax({
						url: ctx + "/weixin-developer/ajaxMain.do?methodName=getSign",
						data: {
							url: window.location.href
						},
						async: false,
						success: function (result) {
							WX.weixin.sign = result;
						}
					});
				return WX.weixin.sign;
			};
			WX.weixin.share = WX.weixin.share || {};
			WX.store = eval('(' + $("#storeObj_val").val() + ')');
			var tempThisUrl = window.location.href;
			WX.weixin.share.title = document.title;
			WX.weixin.share.desc = document.title + "-" + WX.store.short_name;
			if (tempThisUrl.indexOf('alipayapi.jsp') == -1) {
				WX.weixin.share.link = window.location.href;
				WX.weixin.share.img_url = WX.store.logo_url;
				WX.weixin.share.getImg_url = function () { return WX.weixin.share.img_url; };
				WX.weixin.share.getLink = function () {
					if (urlParam.getUrlParam('openid', WX.weixin.share.link)) {
						WX.weixin.share.link = urlParam.replaceParamVal('openid', '', WX.weixin.share.link)
					}
					return WX.weixin.share.link;
				};
			}
			//获取 分享相关 数据的 接口, 方便其他地方 动态更改 分享的 相关数据, 点击分享 调用的时候跟随变化
			WX.weixin.share.getTitle = function () { return WX.weixin.share.title; };
			WX.weixin.share.getDesc = function () { return WX.weixin.share.desc; };

			//	alert("时间戳:"+WX.weixin.getSign().timestamp+",随机数:"+WX.weixin.getSign().nonceStr+",签名:"+WX.weixin.getSign().signature);
			wx.config({
				debug: false, // 开启调试模式,调用的所有api的返回值会在客户端alert出来，若要查看传入的参数，可以在pc端打开，参数信息会通过log打出，仅在pc端时才会打印。
				appId: WX.weixin.appID, 					// 必填，公众号的唯一标识
				timestamp: WX.weixin.getSign().timestamp, 	// 必填，生成签名的时间戳
				nonceStr: WX.weixin.getSign().nonceStr, 	// 必填，生成签名的随机串
				signature: WX.weixin.getSign().signature,	// 必填，签名，见附录1
				jsApiList: ['checkJsApi', 'onMenuShareTimeline', 'onMenuShareAppMessage', 'onMenuShareQQ', 'onMenuShareWeibo', 'onMenuShareWeibo', 'getLocation', 'addCard'] // 必填，需要使用的JS接口列表，所有JS接口列表见附录2
			});
			//验证 JS 接口 是否可用
			wx.checkJsApi({
				jsApiList: ['onMenuShareTimeline', 'onMenuShareAppMessage', 'onMenuShareQQ', 'addCard'], // 需要检测的JS接口列表，所有JS接口列表见附录2,
				success: function (res) {
				}
			});

			wx.ready(function () {
				wx.miniProgram.getEnv(function (res) {
					if (res.miniprogram) {
						// 小程序openid
						if (urlParam.getUrlParam('minaOpenid')) {
							cookieFunc.setCookie('minaOpenid', urlParam.getUrlParam('minaOpenid'), 720);
						} else if (urlParam.getUrlParam('minaOpenid', decodeURIComponent(urlParam.getUrlParam('fromUrl')).split('?')[1])) {
							cookieFunc.setCookie('minaOpenid', urlParam.getUrlParam('minaOpenid', decodeURIComponent(urlParam.getUrlParam('fromUrl')).split('?')[1]), 720);
						}
						if (urlParam.getUrlParam('minaLat')) {
							cookieFunc.setCookie('minaLat', urlParam.getUrlParam('minaLat'), 720);
						} else if (urlParam.getUrlParam('minaLat', decodeURIComponent(urlParam.getUrlParam('fromUrl')).split('?')[1])) {
							cookieFunc.setCookie('minaLat', urlParam.getUrlParam('minaLat', decodeURIComponent(urlParam.getUrlParam('fromUrl')).split('?')[1]), 720);
						}
						if (urlParam.getUrlParam('minaLng')) {
							cookieFunc.setCookie('minaLng', urlParam.getUrlParam('minaLng'), 720);
						} else if (urlParam.getUrlParam('minaLng', decodeURIComponent(urlParam.getUrlParam('fromUrl')).split('?')[1])) {
							cookieFunc.setCookie('minaLng', urlParam.getUrlParam('minaLng', decodeURIComponent(urlParam.getUrlParam('fromUrl')).split('?')[1]), 720);
						}
					} else {
						cookieFunc.removeCookie('minaOpenid');
						cookieFunc.removeCookie('minaLat');
						cookieFunc.removeCookie('minaLng');
					}
				})
				// config信息验证后会执行ready方法，所有接口调用都必须在config接口获得结果之后，
				//config是一个客户端的异步操作，所以如果需要在页面加载时就调用相关接口，则须把相关接口放在ready函数中调用来确保正确执行。
				//对于用户触发时才调用的接口，则可以直接调用，不需要放在ready函数中。
				if (tempThisUrl.indexOf('activity/main.do?id=') != -1 ||
					tempThisUrl.indexOf('methodName=goMain') != -1 ||
					tempThisUrl.indexOf('page/main.do?methodName=goFullFrameScenario') != -1 ||
					tempThisUrl.indexOf('page/main.do') != -1 ||
					tempThisUrl.indexOf('activity/main.do?methodName=list') != -1 ||
					tempThisUrl.indexOf('activity/main.do?methodName=group') != -1 ||
					tempThisUrl.indexOf('activity/main.do?methodName=getProductNavPromotion') != -1 ||
					tempThisUrl.indexOf('alipayapi.jsp') != -1 ||
					tempThisUrl.indexOf('gift/main.do?methodName=detail') != -1 ||
					tempThisUrl.indexOf('eticket/main.do') != -1 ||
					tempThisUrl.indexOf('questionaire/main.do?id=') != -1 ||
					tempThisUrl.indexOf('questionaire/main.do?methodName=showResult') != -1 ||
					tempThisUrl.indexOf('activityShare/main.do?methodName=share') != -1 ||
					tempThisUrl.indexOf('activity/lotteryActivity/main.do') != -1 ||
					tempThisUrl.indexOf('haggle/main.do') != -1 ||
					tempThisUrl.indexOf('user-center/main.do?methodName=orderList') != -1 ||
					tempThisUrl.indexOf('user-center/main.do?methodName=selfOrderList') != -1 ||
					tempThisUrl.indexOf('user-center/main.do?methodName=eTicketOrderList') != -1 ||
					tempThisUrl.indexOf('user-center/main.do?methodName=categoryList') != -1 ||
					tempThisUrl.indexOf('pay_success.jsp') != -1 ||
					tempThisUrl.indexOf('inviteCustomShare.do') != -1 ||
					tempThisUrl.indexOf('coupon/toGrant.do') != -1 ||
					tempThisUrl.indexOf('coupon/grant.do') != -1 ||
					tempThisUrl.indexOf('inviteCustomShare.jsp') != -1
				) {
					wx.showOptionMenu();
				} else {
					wx.hideOptionMenu();
				}
				WX.weixin.share.getOptions = function (options) {
					var op = {
						title: WX.weixin.share.getTitle(),
						desc: WX.weixin.share.getDesc(),
						link: WX.weixin.share.getLink(),
						imgUrl: WX.weixin.share.getImg_url(),
						trigger: function (res) {
							// 不要尝试在trigger中使用ajax异步请求修改本次分享的内容，因为客户端分享操作是一个同步操作，这时候使用ajax的回包会还没有返回
							// alert('用户点击发送给朋友');
						},
						success: function (res) {
							//  alert('已分享');
						},
						cancel: function (res) {
							// alert('已取消');
						},
						fail: function (res) {
							// alert(JSON.stringify(res));
						}
					};
					if (options) {
						op.title = options.title || op.title;
						op.desc = options.desc || op.desc;
						op.link = options.link || op.link;
						op.imgUrl = options.imgUrl || op.imgUrl;
						op.trigger = options.trigger || op.trigger;
						op.success = options.success || op.success;
						op.cancel = options.cancel || op.cancel;
						op.fail = options.fail || op.fail;
					}
					return op;
				};
				// 2. 分享接口
				// 2.1 监听“分享给朋友”，按钮点击、自定义分享内容及分享结果接口
				WX.weixin.onMenuShareAppMessage = function (options) {
					wx.onMenuShareAppMessage(WX.weixin.share.getOptions(options));
				};
				// 2.2 监听“分享到朋友圈”按钮点击、自定义分享内容及分享结果接口
				WX.weixin.onMenuShareTimeline = function (options) {
					wx.onMenuShareTimeline(WX.weixin.share.getOptions(options));
				};


				// 2.3 监听“分享到QQ”按钮点击、自定义分享内容及分享结果接口
				WX.weixin.onMenuShareQQ = function (options) {
					wx.onMenuShareQQ(WX.weixin.share.getOptions(options));
				};
				// 2.4 监听“分享到微博”按钮点击、自定义分享内容及分享结果接口
				WX.weixin.onMenuShareWeibo = function (options) {
					wx.onMenuShareWeibo(WX.weixin.share.getOptions(options));
				};

				WX.weixin.resetShareInter = function () {
					WX.weixin.share.resetData();
					WX.weixin.onMenuShareAppMessage();
					WX.weixin.onMenuShareTimeline();
					WX.weixin.onMenuShareQQ();
					WX.weixin.onMenuShareWeibo();
				};
				//默认 调用  重置 对应的接口
				WX.weixin.resetShareInter();

				WX.weixin.share.resetInter();

				// 添加卡券
				WX.weixin.addCard = function (cardId, cardExt, func) {
					wx.addCard({
						cardList: [{
							cardId: cardId,
							cardExt: cardExt
						}], // 需要添加的卡券列表
						success: func || function (res) {
							var cardList = res.cardList; // 添加的卡券列表信息
							//							if(func)
							//								eval(func);
						}
					});
				};
				// 获取地理位置
				WX.weixin.getLocation = function (callbackFn) {
					wx.getLocation({
						type: 'wgs84', // 默认为wgs84的gps坐标，如果要返回直接给openLocation用的火星坐标，可传入'gcj02'
						success: function (res) {
							var latitude = res.latitude; // 纬度，浮点数，范围为90 ~ -90
							var longitude = res.longitude; // 经度，浮点数，范围为180 ~ -180。
							var speed = res.speed; // 速度，以米/每秒计
							var accuracy = res.accuracy; // 位置精度
							var o = { lat: latitude, lng: longitude, speed: speed, accuracy: accuracy };
							if (callbackFn) {
								callbackFn.call(null, o);
							}
						}
					});
				}
			});
			wx.error(function (res) {
				//alert(JSON.stringify(res));
				// config信息验证失败会执行error函数，如签名过期导致验证失败，具体错误信息可以打开config的debug模式查看，
				//也可以在返回的res参数中查看，对于SPA可以在这里更新签名。
			});
			//	alert( "img:"+WX.weixin.share.getImg_url());
			//分享接口 默认实现
		},
		init: function () {
			if (/MicroMessenger/i.test(navigator.userAgent) && ! /wxwork/i.test(navigator.userAgent)) {
				$(function () {
					func.initfunc();
				})
			} else {
				cookieFunc.removeCookie('minaOpenid');
				cookieFunc.removeCookie('minaLat');
				cookieFunc.removeCookie('minaLng');
			}
		}
	};
	module.exports = func;
});
