define('cookies',['require','exports','module'],function(require, exports, module){
	var cookieMod = {
        setCookie: function(name, value, exptime) {//时间单位：小时
            var now = new Date();
            var time = now.getTime();
            time += 1000*60*60*exptime;
            now.setTime(time);
            document.cookie = name+'='+value+';path='+ctx+'/;expires='+now.toUTCString();
        },
        getCookie: function (name){
            var cArr=document.cookie.split('; ');
            for(var i=0;i<cArr.length;i++){
                var cArr2=cArr[i].split('=');
                if(cArr2[0]==name){
                    return cArr2[1];
                }
            }
            return '';
        },
        removeCookie:function (name){
        	cookieMod.setCookie(name, 1, -9);
        }
    };
	module.exports=cookieMod;
})    
;
define('clone',['require','exports','module'],function(require, exports, module){
	//对象和数组的深拷贝 
	var clone =function(sObj){ 
        if(typeof sObj !== "object"){ 
            return sObj; 
        } 
        var s = {}; 
        if(sObj.constructor == Array){ 
            s = []; 
        } 
        for(var i in sObj){ 
            s[i] = clone(sObj[i]); 
        } 
        return s; 
   };
   module.exports=clone;
})    
;
//分页加载
define('pagination',['require','exports','module','jquery','cookies','clone'],function(require, exports, module){
	var $ = require('jquery');
	var cookiesFunc = require('cookies');
	var clone = require('clone');
	var pagesize=20;
	var pagination={
    	init:function(obj){
    		/**
    		 * 		obj={
    		 * 			name		:	'pdlist',					//唯一标示
    		 * 			servlets	:	'show-pd-details,pd-list',	//servlets
    		 * 			list_data	:	{}					,			//数据对象集合
    		 * 			nextPageLabFun	:	function(){
    		 * 						return $("#loadnext").find("li").last();
    		 * 						},				//进入 可视区 获取 加载下一页的标签对象 的方法
    		 * 			ajaxUrl		:	'',							//后台请求的 url(encodeURI(url)之后的值)
    		 * 			hasMore		:	true,						//默认进入页面,是否 还有 第2页数据(如果当前显示不满1页,则无需加载)
    		 * 			callBack	:	function(obj){},			//ajax 之后的回调函数
    		 * 			promptFun	:	function(){},				//没有更多之后的 回调函数
    		 * 			dataFormCookieFun	:	function(obj){ $("#list").find("li").remove()	}	
    		 * 						//如果cookie内有值的回调函数,正常 仅仅是执行 清除 已存在的标签 不排除会有其他业务需求,故 将cookie内存的数据 一同返回
    		 * 			}
    		 */
    		if(!obj.list_data)
    			return false;
    		
    		var list_keys=cookiesFunc.getCookie("list_key");
    		if(list_keys.split(",").indexOf(obj.name)==-1)
    			list_keys=list_keys+","+obj.name;
    		else
    			list_keys=obj.name;
			cookiesFunc.setCookie("list_key",list_keys,1);
    		cookiesFunc.setCookie("list_servlet_"+obj.name,obj.servlets,1);	//存放cookie
    		var hashMore=true;
    		if(obj.hashMore)
    			hashMore=obj.hashMore;
    		var page=0;
    		var tempJsonResult=[];
    		var callBack=obj.callBack;
    		var list_data=obj.list_data;
    		var promptFun=obj.promptFun;
    		var nextPageLabFun=obj.nextPageLabFun;
    		//异步加载下一页
    		function getMoreData(){
    			if(!hashMore){
    				promptFun();
    				return ;
    			}
    			callBack(tempJsonResult);
    			cookiesFunc.setCookie("list_page_"+obj.name,page,1);		//设置 cookie 记录 当前 页面 加载的页数
    			if(tempJsonResult.length<pagesize){
    				hashMore=false;
    				promptFun();
    			}else
    				setData();
    		}
    		function  setData(){
    			page++;
    			tempJsonResult=[];
    			for(var i=pagesize*page,j=0;i<pagesize*(page+1)&&i<list_data.length;i++,j++){
    				tempJsonResult[j]=clone(list_data[i]);
    			}
    			
    		}
    		if(hashMore)
    			setData();
    		var cookie_page=cookiesFunc.getCookie("list_page_"+obj.name);
    		if(cookie_page){
    			for(var i=0;i<cookie_page;i++){
    				getMoreData();
    			}
    		}
    		$(window).scroll(function () {
    			var lastLi = nextPageLabFun();
    			//调用是否进入可视区域函数
    			var isSee = see(lastLi);
    			//if(isSee&&onOff&&hasMore)
				if(isSee)
    				getMoreData();
    		});
    		//判断元素是否进入可视区域 
    		function see(objLiLast) {
    		    //浏览器可视区域的高度 
    		    var see = document.documentElement.clientHeight;
    		    //滚动条滑动的距离 
    		    var winScroll = $(this).scrollTop();
    		    //距离浏览器顶部的 
    		    var lastLisee = $(objLiLast).offset().top;
    		    return lastLisee < (see + winScroll) ? true : false;
    		}
    		return getMoreData;
    	},
    	clearCookie:function(){
    		//获取当前页的 url
    		var urlDatas=window.location.href.split("?");
    		var nowUrl_temp=urlDatas[0];
    		//获取当前页的 请求
    		var nowServlet=nowUrl_temp.substring(nowUrl_temp.lastIndexOf('/')+1);
    		if(urlDatas.length>1){
    			var paramter_temp=urlDatas[1];
        		var pointer= paramter_temp.indexOf("&");
        		if(pointer!=-1)
        			paramter_temp=paramter_temp.substring(0,pointer);
        		nowServlet=nowServlet+"?"+paramter_temp;
    		}
    		
    		
    		//获取所有的 记录列表cookie的对象 key
    		var list_keys=cookiesFunc.getCookie("list_key").split(',');
    		for(var i=0;i<list_keys.length;i++){
    			//获取 当前 对象--对应的 需要cookie的	servlet
    			var servlet=cookiesFunc.getCookie("list_servlet_"+list_keys[i]);
    			if(!servlet)
    				break;
    			//如果当前页面的 servlet 不存在于 当前key记录的　servlets 内,则清除 当前key 对应的所有cookie
    			if(servlet.split(',').indexOf(nowServlet)==-1){
    			//	cookiesFunc.removeArray(list_keys[i]);//首先移除 之前记录的
    				cookiesFunc.removeCookie("list_page_"+list_keys[i]);
    				list_keys[i]=null;
    			}
    		}
    	},
    	
    	
    	ajaxPage:2,
    	ajaxHasMore:true,
    	ajaxInit:function(obj){
    		/**
    		 * obj.name		="user-center-order-list"			//唯一标示
    		 * obj.servlets	="a.do?a=1|||b.do?a=2"			//servlets 不清空cookie的 请求
    		 * obj.hasMore 									默认加载是否还有更多
    		 * obj.getMore(page)	  						ajax 获取数据接口  page=页数
    		 * obj.nextPageLabFun()							获取 最后 一个对象 ,判断时候进入可视区,加载下一页数据
    		 * obj.callBack(result)   						回调函数,设置数据
    		 */
    		if(obj.pageSize)
    			pagesize = obj.pageSize
    		var list_keys=cookiesFunc.getCookie("list_ajax_key");
    		if(list_keys.split("|||").indexOf(obj.name)==-1)
    			list_keys=list_keys+"|||"+obj.name;
    		else
    			list_keys=obj.name;
    		cookiesFunc.setCookie("list_ajax_key",list_keys,1);
    		cookiesFunc.setCookie("list_ajax_servlet_"+obj.name,obj.servlets,1);	//存放cookie
    		if(!obj.hasMore||obj.hasMore==false)
    			pagination.ajaxHasMore=false;
    		var tempJsonResult=[];	//临时数据 记录下一页的数据 
    		var nextPageLabFun=obj.nextPageLabFun;
    		//异步加载下一页 的数据
    		function getMoreData(){
    			pagination.ajaxHasMore=false;
    			tempJsonResult=obj.getMore(pagination.ajaxPage);
    			if(!tempJsonResult)
    				tempJsonResult=[];
    			if(tempJsonResult.length>=pagesize)
    				pagination.ajaxHasMore=true;
    		}
    		if(pagination.ajaxHasMore)
    			getMoreData();	//默认加载第2页的数据
    		//设置 数据 到 页面
    		function setData(){
    			//回写当前数据
    			obj.callBack(tempJsonResult);
    			//如果后面还有更多数据,则继续加载下一页
    			if( pagination.ajaxHasMore){
    				//当前页数+1
    				pagination.ajaxPage++;
    				getMoreData( pagination.ajaxPage);
    				cookiesFunc.setCookie("list_ajax_page_"+obj.name,pagination.ajaxPage,24);
    				return true;
    			}else
    				tempJsonResult=[];
    			return false;
    		}
    		//获取cookie内 记录的 加载的页数
    		var cookie_page=cookiesFunc.getCookie("list_ajax_page_"+obj.name);
    		if(cookie_page&&cookie_page>1){//如果cookie 内有值,且大于1
    			setData();//显示第2页的数据
    			//继续从第3页 开始加载 后续数据
    			for( pagination.ajaxPage=3;pagination.ajaxPage<=cookie_page;pagination.ajaxPage++){
    				getMoreData();
    				setData();
    			}
    		}
    		//滚动条事件,监听 对象 是否进入可视区,
    		$(window).scroll(function () {
    			var lastLi = nextPageLabFun();
    			//调用是否进入可视区域函数
    			var isSee = see(lastLi);
    			//如果 还有更多数据,并且 加载下一页对象 进入可视区,则加载更多数据
    			if(isSee)
    				setData();
    		});
    		//判断元素是否进入可视区域 
    		function see(objLiLast) {
    		    //浏览器可视区域的高度 
    		    var see = document.documentElement.clientHeight;
    		    //滚动条滑动的距离 
    		    var winScroll = $(this).scrollTop();
    		    //距离浏览器顶部的 
    		    var lastLisee = $(objLiLast).offset().top;
    		    return lastLisee < (see + winScroll) ? true : false;
    		}
    		//返回 设置 数据到页面的方法
    		return setData;
    	},
    	ajaxClearCookie:function(){
    		//获取当前页的 url
    		var urlDatas=window.location.href.split("?");
    		var nowUrl_temp=urlDatas[0];
    		//获取当前页的 请求
    		var nowServlet=nowUrl_temp.substring(nowUrl_temp.lastIndexOf('/')+1);
    		if(urlDatas.length>1){
    			var paramter_temp=urlDatas[1];
        		var pointer= paramter_temp.indexOf("&");
        		if(pointer!=-1)
        			paramter_temp=paramter_temp.substring(0,pointer);
        		nowServlet=nowServlet+"?"+paramter_temp;
    		}
    		//获取所有的 记录列表cookie的对象 key
    		var list_keys=cookiesFunc.getCookie("list_ajax_key").split('|||');
    		for(var i=0;i<list_keys.length;i++){
    			//获取 当前 对象--对应的 需要cookie的	servlet
    			var servlet=cookiesFunc.getCookie("list_ajax_servlet_"+list_keys[i]);
    			if(!servlet)
    				break;
    			//如果当前页面的 servlet 不存在于 当前key记录的　servlets 内,则清除 当前key 对应的所有cookie
    			if(servlet.split('|||').indexOf(nowServlet)==-1){
    			//	WX.cookieMod.removeArray(list_keys[i]);//首先移除 之前记录的
    				cookiesFunc.removeCookie("list_ajax_page_"+list_keys[i]);
    				list_keys[i]=null;
    			}
    		}
		}
    };
	module.exports=pagination;
})    
;
//页面跳转
define('page',['require','exports','module'],function(require, exports, module){
	var page={
		getUrl:function(type,id,name,mallType){
			//page:页面,link:自定义外部链接,activity:活动,group:活动分组,joinActivity:加盟活动,coupon：优惠券,card刮刮卡,shake摇一摇,marketActivity全幅画,lucky幸运大抽奖,questionaire调查问卷
			var url="";
			if(type=="goods"||type=="activity"||type=="joinGoods"){		//转到 活动详情
				url=ctx+"/activity/main.do?id="+id+"&storeid="+WX.storeid+"&salesid="+WX.salesid;
			}else if(type=="group"){	//转到 分组列表页面
				if(id==-1){
					url=ctx+"/activity/main.do?methodName=list&storeid="+WX.storeid+"&salesid="+WX.salesid;
				}else
					url=ctx+"/activity/main.do?methodName=group&id="+id+"&storeid="+WX.storeid+"&salesid="+WX.salesid;
			}else if(type=="page"){		//转到 page 页面
				url=ctx+'/page/main.do?id='+id+"&storeid="+WX.storeid+"&salesid="+WX.salesid;;
			}else if(type == 'pointPage') {
                url=ctx+'/jfmall/main.do?id='+id+"&storeid="+WX.storeid+"&salesid="+WX.salesid;
			}else if(type=="productNav"){
				url=ctx+"/activity/main.do?methodName=getProductNavPromotion&storeid="+WX.storeid+"&salesid="+WX.salesid+"&id="+id+"&name="+name+"&type=all&sort=news";
			}else if(type=="coupon"){
				url=ctx+'/coupon/CheckCouponPosTicket.do?couponId='+id+'&storeid='+WX.storeid+'&pushId=&salesid=';
			}else if(type=="card"){
				url=ctx+'/activity/lotteryActivity/main.do?storeid='+WX.storeid+'&activityId='+id+'&salesid=';
			}else if(type=="shake"){
				url=ctx+'/activity/lotteryActivity/main.do?storeid='+WX.storeid+'&activityId='+id+'&salesid=';
			}else if(type=="marketActivity"){
				url=ctx+'/page/main.do?methodName=goFullFrameScenario&id='+id+'&storeid='+WX.storeid+'&salesid=';
			}else if(type=="lucky"){
				url=ctx+'/activity/lotteryActivity/main.do?storeid='+WX.storeid+'&activityId='+id+'&salesid=';
			}else if(type=="questionaire"){
				url=ctx+'/questionaire/main.do?id='+id+'&storeid='+WX.storeid+'&salesid=';
			} else if(type=="limitTimeDiscount") {
				url=ctx+'/activity/main.do?methodName=limitTimeDiscount&storeid='+WX.storeid+'&salesid=';
			}
			if(url=="")
				return false;
			return url;
		},
		refresh:function(url){
			if(url)
				window.location.href=url;
		},
		tempurl:function(jsp){
		   var tempHref=window.location.href;
	       if(tempHref.indexOf("?")!=-1){
 	  			var fromUrl=tempHref.substring(tempHref.indexOf("?")+9);  
	  			if(fromUrl.length>0){
	       		window.location.href=ctx+'/'+jsp+'?fromUrl='+fromUrl;
	  			}else{
	            	window.location.href=ctx+'/'+jsp;
	  			}
	       }else{
	       	window.location.href=ctx+'/'+jsp;
	       }
	   },
	   goControllerUrl:function(jsp){
		   var tempHref=window.location.href;
		   var a=tempHref.indexOf("fromUrl");
	  	   var fromUrl=tempHref.substring(tempHref.indexOf("fromUrl"));
	  	   if(a!=-1){
	  		   window.location.href=ctx+'/'+jsp+'&'+fromUrl;
	  	   }else{
	           window.location.href=ctx+'/'+jsp;
	  	   }
	   }
	};
	module.exports=page;
})    
;
/**
 * 页面提示效果
 */
define('toast',['require','exports','module','jquery'],function(require, exports, module){
	var $ = require("jquery");
	$(function(){
		$("body").append('<div id="toast"><div id="toast_msg"></div></div>');
	});
	module.exports = function toast(time,msg){
		if(!msg||!time)
			return;
		$("#toast_msg").html(msg);
		$("#toast").stop(true).fadeIn(100).delay(time).fadeOut(500);
	}
});
define('urlParam',['require','exports','module'],function(require, exports, module){
	var funcs = {
		getUrlParam: function(name, url) {
			if (!url) {
				url = window.location.search.substr(1)
			}
			var reg = new RegExp("(^|&)" + name + "=([^&]*)(&|$)", "i");
			var r = url.match(reg); 
			if (r != null) return decodeURI(r[2]); return null;
		},
		replaceParamVal: function(paramName,replaceWith,oUrl) {
			if(!oUrl){
				oUrl = window.location.href.toString();
			}
		    var re=eval('/('+ paramName+'=)([^&]*)/gi');  
		    var nUrl = oUrl.replace(re,paramName+'='+replaceWith);  
		    return nUrl;  
		}  
	};
	module.exports=funcs;
})    
;
define('init',['require','exports','module','jquery','cookies','pagination','page','toast','urlParam'],function(require,exports,module){
	var $=require("jquery");
	var cookieFunc=require("cookies");
	var paginationFunc=require("pagination");
	var pageFunc=require("page");
	var toast = require("toast");
	var urlParam = require("urlParam");
	var funcs={
		init:function(){			
			window.WX=window.WX||{};
			if($("#storeObj_val").val()!="")
				WX.store=eval('('+$("#storeObj_val").val()+')');
			WX.storeid=$("#storeid_val").val();			//当前商户ID
			WX.salesid=$("#salesid_val").val();			//当前销售ID
			$.ajaxSetup({
		       contentType:"application/x-www-form-urlencoded;charset=utf-8",
		       complete:function(XMLHttpRequest,textStatus){
		    	   //通过XMLHttpRequest取得响应头，sessionstatus，
		           var sessionstatus=XMLHttpRequest.getResponseHeader("sessionstatus");
		           console.log("ajax complete!");
		           if(sessionstatus=="timeout"){
		               //如果超时就处理 ，指定要跳转的页面
		               //window.location.replace(ctx+"/login.jsp?fromUrl="+window.location.href);
		        	   //登录跳转修改
		        	   window.location.replace(ctx+"/user/main.do?methodName=goLogin&storeid="+WX.storeid+"&salesid="+WX.salesid+"&fromUrl="+encodeURIComponent(window.location.href.replace(window.location.origin,"")));
		        	   toast(1000,"请先登录");
		           }
		       }
		    });
			/*confirm控件开始*/
			var confirmHtml=
				'<div class="confirm-mask" style="display:none">'+
					'<div class="animated fast confirm-modal">'+
						'<div class="confirm-content">'+
							'<p class="confirm-string"></p>'+
						'</div>'+
						'<div class="confirm-foot clearfix">'+
							'<button class="btn-confirm pull-l">确认</button>'+
							'<button class="btn-cancel pull-r">关闭</button>'+
						'</div>'+
					'</div>'+
				'</div>';
			$('body').append(confirmHtml);
			$.confirm = (function(msg,callback,callbackCansel){
				if(typeof(msg) === 'string'){
					$('.confirm-mask .confirm-string').text(msg);
				}else if(typeof(msg) === 'object'){
					$('.confirm-mask .confirm-string').html(msg.contentText);
					$('.confirm-modal .btn-confirm').text(msg.confirmText);
					$('.confirm-modal .btn-cancel').text(msg.cancelText);
				}
				$('.confirm-mask').fadeIn();
				$('.confirm-modal').removeClass('fadeOutUp').addClass('fadeInDown');
				$('.confirm-modal .btn-confirm').unbind('click');
				$('.confirm-modal .btn-confirm').on('click',function(){
					console.log('confirm');
					if(callback)callback(true);
					$('.confirm-mask').fadeOut();
					$('.confirm-modal').removeClass('fadeInDown').addClass('fadeOutUp');
				})
				$('.confirm-modal .btn-cancel').on('click',function(){
					if(callbackCansel)callbackCansel(true);
					$('.confirm-mask').fadeOut();
					$('.confirm-modal').removeClass('fadeInDown').addClass('fadeOutUp');
				});
			})
			/*confirm控件结束*/
			/*prompt控件开始*/
			var promptHtml=
				'<div class="prompt-mask" style="display:none">'+
					'<div class="animated fast prompt-modal">'+
						'<span class="close-prompt"></span>'+
						'<div class="prompt-head">'+
							'<h4 class="prompt-string">请输入</h4>'+
						'</div>'+
						'<div class="prompt-content">'+
							'<input type="tel" maxlength="50" class="prompt-input"/>'+
						'</div>'+
						'<div class="prompt-foot clearfix">'+
							'<button class="btn-confirm">确认</button>'+
						'</div>'+
					'</div>'+
				'</div>';
			$('body').append(promptHtml);
			$('.prompt-modal .close-prompt').on('click',function(){
				$('.prompt-mask').fadeOut();
				$('.prompt-modal').removeClass('fadeInDown').addClass('fadeOutUp');
			})
			$.prompt = (function(msg,callback){
				$('.prompt-mask .prompt-string').text(msg);
				$('.prompt-mask').fadeIn();
				$('.prompt-modal').removeClass('fadeOutUp').addClass('fadeInDown');
				$('.prompt-modal .btn-confirm').unbind('click');
				$('.prompt-modal .btn-confirm').on('click',function(){
					console.log('prompt');
					if(callback)callback($('.prompt-mask .prompt-input').val());
				})
			})
			/*prompt控件结束*/
			/* 格式化日期函数 */
			Date.prototype.format =function(format){
				var o = {
					"M+" : this.getMonth()+1, //month
					"d+" : this.getDate(), //day
					"h+" : this.getHours(), //hour
					"m+" : this.getMinutes(), //minute
					"s+" : this.getSeconds(), //second
					"q+" : Math.floor((this.getMonth()+3)/3), //quarter
					"S" : this.getMilliseconds() //millisecond
				}
				if(/(y+)/.test(format))
					format=format.replace(RegExp.$1, (this.getFullYear()+"").substr(4- RegExp.$1.length));
				for(var k in o)
					if(new RegExp("("+ k +")").test(format))
						format = format.replace(RegExp.$1,
					RegExp.$1.length==1? o[k] :	("00"+ o[k]).substr((""+ o[k]).length));
				return format;
			};
			//重置 cookie 内的值
			cookieFunc.setCookie("storeid",WX.storeid,24);
			cookieFunc.setCookie("salesid",WX.salesid,24);

			WX.page=pageFunc;
			$(function(){
				paginationFunc.clearCookie();		//清除分页cookie
				paginationFunc.ajaxClearCookie();
			    if (!/MicroMessenger/i.test(navigator.userAgent))//加载完毕之后 判断 是否微信浏览器 隐藏 关注按钮
					$("[id='weixin_attention']").hide();
		    });
			function jconfirm(msg,callback){
		        	if(null==msg){msg="确认操作吗？"}else{$("#confirm_title").html(msg)};
		        	$("#confirm_dialog").modal("show");
		        	$("#confirm_ok").unbind();
		        	$("#confirm_ok").click( function() {
		        		$("#confirm_dialog").modal("hide");
		        		if(callback)callback(true);
		        	})
		        }
			/* 搜索 */
			$(".head-search").on("click",function(){
				$.ajax({
					url: ctx+"/keyWord/ajaxMain.do?methodName=getkeyword",
					success: function(jsonArr){
						var dataStr='';
						for(var i = 0;i<jsonArr.length;i++){
							dataStr+='<a data-keywords="'+jsonArr[i].name+'"> <span>'+jsonArr[i].name+'</span> </a>';
						}
						$(".search_hot").empty();
						$(".search_hot").append(dataStr);
						window.location.hash="search";
						$(".search-poup").fadeIn();
						$(".search_hot a").on("click", function(ev){
							ev.preventDefault();
							ev.stopPropagation();
							var keyWord = $(this).attr("data-keywords");
							window.location.href=ctx+"/activity/main.do?methodName=list&storeid="+WX.storeid+"&searchValue="+encodeURIComponent(encodeURIComponent(keyWord));
						});
					}
				});
			});
			$("[id='hide_search_btn']").on("click",function(e){
				e.preventDefault();
				e.stopPropagation();
				var searchVal = $.trim($(this).prev(".gewei_search").val());
				if(searchVal == ""){
					toast(1000,"搜索条件不能为空");
					return false;
				} else {
					window.location.href=ctx+"/activity/main.do?methodName=list&storeid="+WX.storeid+"&searchValue="+encodeURIComponent(encodeURIComponent($(this).prev().val()));
				}
			});
			$(".gewei_search").on("keypress",function(event){//回车搜索
				var keywhich = (event.keyCode? event.keyCode:event.which);
				if(keywhich == 13){
					event.preventDefault();
					$("[id='hide_search_btn']").click();
				}
			});
			// 取消搜索
			$(".cancel-search").on("click", function(ev){
				ev.preventDefault();
				ev.stopPropagation();
				window.location.hash="";
			});
			$("body").on("focus", ".searchInput", function(){
				var aHeight = $(window).height()-$(this).height()-[$(this).offset().top-$(document).scrollTop()];
				if(aHeight < $(window).height()/2 ){
					$("html,body").animate({scrollTop:$(this).offset().top - 100},100);
				}
			});
			$("body").on("blur", ".searchInput", function(){
				$("html,body").animate({scrollTop: "auto"},100);
			});
			//只能输入数字
			$("body").on("keypress","input[data-inputtype='number']",function(event){
				var k = event.keyCode
		        if(((k >= 48) && (k <= 57)) || k == 8 || k == 0){

		        }else{
		        	event.preventDefault();
		        }
			});
			//限制字节数
			$(document).on("keyup","input[data-inputtype='bytelimit']",function(event){
				var maxLen=parseInt($(this).attr("data-bytelimit"));
				WidthCheck(this, maxLen);
			});
			$(document).on("change","input[data-inputtype='bytelimit']",function(event){
				var maxLen=parseInt($(this).attr("data-bytelimit"));
				WidthCheck(this, maxLen);
			});
			function WidthCheck(str, maxLen) {
			  var w = 0;
			  var tempCount = 0;
			  //length 获取字数数，不区分汉子和英文
			  for (var i = 0; i < str.value.length; i++) {
			    //charCodeAt()获取字符串中某一个字符的编码
			    var c = str.value.charCodeAt(i);
			    //单字节加1
			    if ((c >= 0x0001 && c <= 0x007e) || (0xff60 <= c && c <= 0xff9f)) {
			      w++;
			    } else {
			      w += 2;
			    }
			    if (w > maxLen) {
			      str.value = str.value.substr(0, i);
			      break;
			    }
			  }
			}

			//显示搜索页的时候，点击浏览器返回按钮，隐藏搜索页
			window.onhashchange=function(){
				if(window.location.hash!="#search"){
					$(".gewei_search").val("");
					$(".search-poup").fadeOut();
				}
			};
			function getFilterUrl() {
				var tempHref = window.location.pathname;
				if(urlParam.getUrlParam('methodName')) {
					tempHref += '?methodName=' + urlParam.getUrlParam('methodName');
				}
				return tempHref;
			}
			$(function(){
				$("#loading").hide();
				// 需要显示顶部部收货地址的链接
				var showBottomAddressUrls = [
					 ctx + '/page/main.do',
					 ctx + '/page/main.do?methodName=goMain',
					 ctx + '/page/main.do?methodName=productNav',
					 ctx + '/activity/main.do?methodName=getProductNavPromotion',
					 ctx + '/activity/main.do?methodName=group',
					 ctx + '/activity/main.do?methodName=list'
				];
                // 外卖弹窗
                $('.takeout-alert-modal-hide').click(function () {
                    $('.takeout-alert-modal').removeClass('active');
                    window.sessionStorage.setItem('noTakeAwayNotSupportAlert_' + WX.storeid, true);
                })
				// 外卖商城页面底部收货地址显示
				if(storeCongigObj.takeawayStatus == '1' && showBottomAddressUrls.indexOf(getFilterUrl()) >= 0 && window.sessionStorage.getItem('takeAwayAddress_' + parentStoreId)){
				    var takeAwayAddress = '',
                        takeAwayTips = '';
				    if (window.sessionStorage.getItem('takeAwayAddress_' + parentStoreId) == 'empty') { // 未选择地址
                        takeAwayAddress = '暂无地址';
                        if (storeCongigObj.supportTakeOut == '1') {
                            takeAwayTips = '本门店支持'+storeCongigObj.deliveryArea+'公里内同城外卖'
                        } else {
                            takeAwayTips = '本门店不支持同城外卖';
                            if (!window.sessionStorage.getItem('noTakeAwayNotSupportAlert_' + WX.storeid)) {
                                $('#takeoutAlertModalNoSupportTips').show();
                                $('#takeoutAlertModalNoReachTips').hide();
                                $('.takeout-alert-modal').addClass('active')
                            }
                        }
                    } else { // 已选地址
                        takeAwayAddress = JSON.parse(window.sessionStorage.getItem('takeAwayAddress_' + parentStoreId)).addressName;
                        if (storeCongigObj.supportTakeOut == '1') {
                            $.ajax({
                                url: ctx + '/address/getStoreDistance.do',
                                type: 'post',
                                async: false,
                                data: {
                                    addressId: JSON.parse(window.sessionStorage.getItem('takeAwayAddress_' + parentStoreId)).addressId
                                },
                                success: function (res) {
                                    var canReachTakeout = false;
                                    if (res.code == 1 && res.data < parseFloat(storeCongigObj.deliveryArea)) {
                                        canReachTakeout = true;
                                    }
                                    if (!canReachTakeout) {
                                        takeAwayTips = '超出范围';
                                        if (!window.sessionStorage.getItem('noTakeAwayNotSupportAlert_' + WX.storeid)) {
                                            $('#takeoutAlertModalNoSupportTips').hide();
                                            $('#takeoutAlertModalNoReachTips').show();
                                            $('.takeout-alert-modal').addClass('active')
                                        }
                                    } else {
                                        takeAwayTips = '可外卖配送';
                                    }
                                }
                            })
                        } else {
                            takeAwayTips = '不支持外卖';
                            if (!window.sessionStorage.getItem('noTakeAwayNotSupportAlert_' + WX.storeid)) {
                                $('#takeoutAlertModalNoSupportTips').show();
                                $('#takeoutAlertModalNoReachTips').hide();
                                $('.takeout-alert-modal').addClass('active')
                            }
                        }
                    }
					var takeAwayHtml =
						'<a class="bot-take-away-address" style="top: 0;position: fixed;" href="'+ctx+'/address/main.do?methodName=takeAway&storeid='+WX.storeid+'&salesid=&fromUrl='+encodeURIComponent(window.location.href)+'">\
							<div class="clearfix">\
								<img class="pull-l" src="'+resourcePath+'/img/takeAway/location-white.png"/>\
								<span class="pull-l">'+takeAwayAddress+'</span>\
								<img class="pull-l" style="height: 10px;margin: 5px 0 0 8px;" src="'+resourcePath+'/img/takeAway/arrow-r.png"/>\
								<span class="pull-r" style="color: #ff8d5c">'+takeAwayTips+'</span>\
							</div>\
						</a>\
						<div style="height: 37px"></div>'
					$('.head').before(takeAwayHtml);
				}

				// 是否歇业判断
				var nowHour = new Date().getHours(),
					mallStartTime = parseInt(storeCongigObj.mallTime.split('-')[0].split(':')[0]),
					mallEndTime = parseInt(storeCongigObj.mallTime.split('-')[1].split(':')[0]),
					showMallCloseUrls = [
    					 ctx + '/page/main.do',
    					 ctx + '/page/main.do?methodName=goMain',
    					 ctx + '/page/main.do?methodName=productNav',
    					 ctx + '/activity/main.do?methodName=getProductNavPromotion',
    					 ctx + '/activity/main.do?methodName=group',
    					 ctx + '/activity/main.do?methodName=list',
    					 ctx + '/shopCart/shopCartList.do',
    					 ctx + '/activity/main.do',
    					 ctx + '/order/main.do'
    				];
				if((storeCongigObj.mallOpenStatus == '0' || nowHour < mallStartTime || nowHour >= mallEndTime) && showMallCloseUrls.indexOf(getFilterUrl()) >= 0){
					var goLink = '';
					if(storeCongigObj.takeawayStatus == '1'){ // 外卖商城跳转地址选择
						goLink = ctx + '/address/main.do?methodName=takeAway&storeid=' + WX.storeid + '&salesid=&fromUrl=' + encodeURIComponent(window.location.href)
					}else{
						if(!storeCongigObj.storeStatus || storeCongigObj.storeStatus == '1'){
							goLink = ctx + '/user-center/main.do?methodName=myStoreAndSubList&storeid=' + WX.storeid;
						}else{
							goLink = ctx + '/user-center/main.do?methodName=memberCenter&storeid=' + WX.storeid;
						}
					}
					var mallCloseHtml =
						'<div class="mall-close-mask">\
							<div class="mall-close-container">\
								<div class="mall-close-content">\
									<img src="'+resourcePath+'/img/takeAway/rest.png"/>\
									<p>'+storeCongigObj.storeName+'歇业中</p>\
								</div>\
								<div class="mall-close-button"><a class="btn" href="'+goLink+'">再看看</a></div>\
							</div>\
						</div>';
					$('body').append(mallCloseHtml);
				}

				// 头部门店列表跳转
				$('.head-show-store-list').on('click',function(){
					window.location.href=ctx+'/user-center/main.do?methodName=myStoreAndSubList&storeid='+WX.storeid+'&salesid='+WX.salesid;
				})
				if($('.menu-container').length > 0){
					// 菜单
					$.ajax({
						url: ctx + '/memberCenter/sideMenu/list.do?storeId=' + WX.storeid,
						type: 'post',
						success: function(response){
							$.each(response.data, function(index, menu){
								if(menu.display==1){
									$('.menu-body').append('<div class="menu-item" onclick="'+'window.location.href=\''+menu.url+'\''+'">'+menu.name+'</div>');
								}
							})
						}
					})
					if(navigator.userAgent.toLowerCase().match(/MicroMessenger/i) == 'micromessenger'){
						$('.menu-footer .login-out').hide();
					}
					$('.float-back-icon').click(function(){//返回到会员中心
						/*window.history.go(-1);*/
						window.location.href=ctx+'/user-center/main.do?methodName=memberCenter&storeid='+WX.storeid+'&salesid='+WX.salesid;
					})
					$('.float-menu-icon').click(function(){
						$('.menu-mask').fadeIn(500);
						$('.menu-container').addClass('active');
					})
					$('.menu-mask, .menu-hide').click(function(){
						$('.menu-mask').fadeOut(500);
						$('.menu-container').removeClass('active');
					})
				}
			})
		}
	};
	module.exports=funcs;
});

define('weixin',['require','exports','module','jweixin','cookies','urlParam'],function (require, exports, module) {
	var wx = require("jweixin");
	var cookieFunc = require("cookies");
	var urlParam = require("urlParam");
	window.wx = wx;
	var func = {
		initfunc: function () {
			window.WX = window.WX || {};
			WX.weixin = {};
			//设置分享 相关的 url 图片url 内容
			WX.weixin.share = {};	//定义分享对象
			WX.weixin = WX.weixin || {};
			WX.weixin.appID = getAppId();
			function getAppId() {
				var appId = 'wx0376eb564b516c7c';
				$.ajax({
					url: ctx + "/weixin-developer/ajaxMain.do?methodName=getAppId",
					async: false,
					success: function (result) {
						appId = result;
					}
				});
				return appId;
			}
			//设置分享 相关的 url 图片url 内容
			WX.weixin.share = WX.weixin.share || {};	//定义分享对象
			WX.weixin.share.resetData = WX.weixin.share.resetData || function () { };//定义 重置接口数据的接口,方便外部重写
			WX.weixin.share.resetInter = WX.weixin.share.resetInter || function () { };
			//获取 签名
			WX.weixin.getSign = function () {
				if (!WX.weixin.sign)
					$.ajax({
						url: ctx + "/weixin-developer/ajaxMain.do?methodName=getSign",
						data: {
							url: window.location.href
						},
						async: false,
						success: function (result) {
							WX.weixin.sign = result;
						}
					});
				return WX.weixin.sign;
			};
			WX.weixin.share = WX.weixin.share || {};
			WX.store = eval('(' + $("#storeObj_val").val() + ')');
			var tempThisUrl = window.location.href;
			WX.weixin.share.title = document.title;
			WX.weixin.share.desc = document.title + "-" + WX.store.short_name;
			if (tempThisUrl.indexOf('alipayapi.jsp') == -1) {
				WX.weixin.share.link = window.location.href;
				WX.weixin.share.img_url = WX.store.logo_url;
				WX.weixin.share.getImg_url = function () { return WX.weixin.share.img_url; };
				WX.weixin.share.getLink = function () {
					if (urlParam.getUrlParam('openid', WX.weixin.share.link)) {
						WX.weixin.share.link = urlParam.replaceParamVal('openid', '', WX.weixin.share.link)
					}
					return WX.weixin.share.link;
				};
			}
			//获取 分享相关 数据的 接口, 方便其他地方 动态更改 分享的 相关数据, 点击分享 调用的时候跟随变化
			WX.weixin.share.getTitle = function () { return WX.weixin.share.title; };
			WX.weixin.share.getDesc = function () { return WX.weixin.share.desc; };

			//	alert("时间戳:"+WX.weixin.getSign().timestamp+",随机数:"+WX.weixin.getSign().nonceStr+",签名:"+WX.weixin.getSign().signature);
			wx.config({
				debug: false, // 开启调试模式,调用的所有api的返回值会在客户端alert出来，若要查看传入的参数，可以在pc端打开，参数信息会通过log打出，仅在pc端时才会打印。
				appId: WX.weixin.appID, 					// 必填，公众号的唯一标识
				timestamp: WX.weixin.getSign().timestamp, 	// 必填，生成签名的时间戳
				nonceStr: WX.weixin.getSign().nonceStr, 	// 必填，生成签名的随机串
				signature: WX.weixin.getSign().signature,	// 必填，签名，见附录1
				jsApiList: ['checkJsApi', 'onMenuShareTimeline', 'onMenuShareAppMessage', 'onMenuShareQQ', 'onMenuShareWeibo', 'onMenuShareWeibo', 'getLocation', 'addCard'] // 必填，需要使用的JS接口列表，所有JS接口列表见附录2
			});
			//验证 JS 接口 是否可用
			wx.checkJsApi({
				jsApiList: ['onMenuShareTimeline', 'onMenuShareAppMessage', 'onMenuShareQQ', 'addCard'], // 需要检测的JS接口列表，所有JS接口列表见附录2,
				success: function (res) {
				}
			});

			wx.ready(function () {
				wx.miniProgram.getEnv(function (res) {
					if (res.miniprogram) {
						// 小程序openid
						if (urlParam.getUrlParam('minaOpenid')) {
							cookieFunc.setCookie('minaOpenid', urlParam.getUrlParam('minaOpenid'), 720);
						} else if (urlParam.getUrlParam('minaOpenid', decodeURIComponent(urlParam.getUrlParam('fromUrl')).split('?')[1])) {
							cookieFunc.setCookie('minaOpenid', urlParam.getUrlParam('minaOpenid', decodeURIComponent(urlParam.getUrlParam('fromUrl')).split('?')[1]), 720);
						}
						if (urlParam.getUrlParam('minaLat')) {
							cookieFunc.setCookie('minaLat', urlParam.getUrlParam('minaLat'), 720);
						} else if (urlParam.getUrlParam('minaLat', decodeURIComponent(urlParam.getUrlParam('fromUrl')).split('?')[1])) {
							cookieFunc.setCookie('minaLat', urlParam.getUrlParam('minaLat', decodeURIComponent(urlParam.getUrlParam('fromUrl')).split('?')[1]), 720);
						}
						if (urlParam.getUrlParam('minaLng')) {
							cookieFunc.setCookie('minaLng', urlParam.getUrlParam('minaLng'), 720);
						} else if (urlParam.getUrlParam('minaLng', decodeURIComponent(urlParam.getUrlParam('fromUrl')).split('?')[1])) {
							cookieFunc.setCookie('minaLng', urlParam.getUrlParam('minaLng', decodeURIComponent(urlParam.getUrlParam('fromUrl')).split('?')[1]), 720);
						}
					} else {
						cookieFunc.removeCookie('minaOpenid');
						cookieFunc.removeCookie('minaLat');
						cookieFunc.removeCookie('minaLng');
					}
				})
				// config信息验证后会执行ready方法，所有接口调用都必须在config接口获得结果之后，
				//config是一个客户端的异步操作，所以如果需要在页面加载时就调用相关接口，则须把相关接口放在ready函数中调用来确保正确执行。
				//对于用户触发时才调用的接口，则可以直接调用，不需要放在ready函数中。
				if (tempThisUrl.indexOf('activity/main.do?id=') != -1 ||
					tempThisUrl.indexOf('methodName=goMain') != -1 ||
					tempThisUrl.indexOf('page/main.do?methodName=goFullFrameScenario') != -1 ||
					tempThisUrl.indexOf('page/main.do') != -1 ||
					tempThisUrl.indexOf('activity/main.do?methodName=list') != -1 ||
					tempThisUrl.indexOf('activity/main.do?methodName=group') != -1 ||
					tempThisUrl.indexOf('activity/main.do?methodName=getProductNavPromotion') != -1 ||
					tempThisUrl.indexOf('alipayapi.jsp') != -1 ||
					tempThisUrl.indexOf('gift/main.do?methodName=detail') != -1 ||
					tempThisUrl.indexOf('eticket/main.do') != -1 ||
					tempThisUrl.indexOf('questionaire/main.do?id=') != -1 ||
					tempThisUrl.indexOf('questionaire/main.do?methodName=showResult') != -1 ||
					tempThisUrl.indexOf('activityShare/main.do?methodName=share') != -1 ||
					tempThisUrl.indexOf('activity/lotteryActivity/main.do') != -1 ||
					tempThisUrl.indexOf('haggle/main.do') != -1 ||
					tempThisUrl.indexOf('user-center/main.do?methodName=orderList') != -1 ||
					tempThisUrl.indexOf('user-center/main.do?methodName=selfOrderList') != -1 ||
					tempThisUrl.indexOf('user-center/main.do?methodName=eTicketOrderList') != -1 ||
					tempThisUrl.indexOf('user-center/main.do?methodName=categoryList') != -1 ||
					tempThisUrl.indexOf('pay_success.jsp') != -1 ||
					tempThisUrl.indexOf('inviteCustomShare.do') != -1 ||
					tempThisUrl.indexOf('coupon/toGrant.do') != -1 ||
					tempThisUrl.indexOf('coupon/grant.do') != -1 ||
					tempThisUrl.indexOf('inviteCustomShare.jsp') != -1
				) {
					wx.showOptionMenu();
				} else {
					wx.hideOptionMenu();
				}
				WX.weixin.share.getOptions = function (options) {
					var op = {
						title: WX.weixin.share.getTitle(),
						desc: WX.weixin.share.getDesc(),
						link: WX.weixin.share.getLink(),
						imgUrl: WX.weixin.share.getImg_url(),
						trigger: function (res) {
							// 不要尝试在trigger中使用ajax异步请求修改本次分享的内容，因为客户端分享操作是一个同步操作，这时候使用ajax的回包会还没有返回
							// alert('用户点击发送给朋友');
						},
						success: function (res) {
							//  alert('已分享');
						},
						cancel: function (res) {
							// alert('已取消');
						},
						fail: function (res) {
							// alert(JSON.stringify(res));
						}
					};
					if (options) {
						op.title = options.title || op.title;
						op.desc = options.desc || op.desc;
						op.link = options.link || op.link;
						op.imgUrl = options.imgUrl || op.imgUrl;
						op.trigger = options.trigger || op.trigger;
						op.success = options.success || op.success;
						op.cancel = options.cancel || op.cancel;
						op.fail = options.fail || op.fail;
					}
					return op;
				};
				// 2. 分享接口
				// 2.1 监听“分享给朋友”，按钮点击、自定义分享内容及分享结果接口
				WX.weixin.onMenuShareAppMessage = function (options) {
					wx.onMenuShareAppMessage(WX.weixin.share.getOptions(options));
				};
				// 2.2 监听“分享到朋友圈”按钮点击、自定义分享内容及分享结果接口
				WX.weixin.onMenuShareTimeline = function (options) {
					wx.onMenuShareTimeline(WX.weixin.share.getOptions(options));
				};


				// 2.3 监听“分享到QQ”按钮点击、自定义分享内容及分享结果接口
				WX.weixin.onMenuShareQQ = function (options) {
					wx.onMenuShareQQ(WX.weixin.share.getOptions(options));
				};
				// 2.4 监听“分享到微博”按钮点击、自定义分享内容及分享结果接口
				WX.weixin.onMenuShareWeibo = function (options) {
					wx.onMenuShareWeibo(WX.weixin.share.getOptions(options));
				};

				WX.weixin.resetShareInter = function () {
					WX.weixin.share.resetData();
					WX.weixin.onMenuShareAppMessage();
					WX.weixin.onMenuShareTimeline();
					WX.weixin.onMenuShareQQ();
					WX.weixin.onMenuShareWeibo();
				};
				//默认 调用  重置 对应的接口
				WX.weixin.resetShareInter();

				WX.weixin.share.resetInter();

				// 添加卡券
				WX.weixin.addCard = function (cardId, cardExt, func) {
					wx.addCard({
						cardList: [{
							cardId: cardId,
							cardExt: cardExt
						}], // 需要添加的卡券列表
						success: func || function (res) {
							var cardList = res.cardList; // 添加的卡券列表信息
							//							if(func)
							//								eval(func);
						}
					});
				};
				// 获取地理位置
				WX.weixin.getLocation = function (callbackFn) {
					wx.getLocation({
						type: 'wgs84', // 默认为wgs84的gps坐标，如果要返回直接给openLocation用的火星坐标，可传入'gcj02'
						success: function (res) {
							var latitude = res.latitude; // 纬度，浮点数，范围为90 ~ -90
							var longitude = res.longitude; // 经度，浮点数，范围为180 ~ -180。
							var speed = res.speed; // 速度，以米/每秒计
							var accuracy = res.accuracy; // 位置精度
							var o = { lat: latitude, lng: longitude, speed: speed, accuracy: accuracy };
							if (callbackFn) {
								callbackFn.call(null, o);
							}
						}
					});
				}
			});
			wx.error(function (res) {
				//alert(JSON.stringify(res));
				// config信息验证失败会执行error函数，如签名过期导致验证失败，具体错误信息可以打开config的debug模式查看，
				//也可以在返回的res参数中查看，对于SPA可以在这里更新签名。
			});
			//	alert( "img:"+WX.weixin.share.getImg_url());
			//分享接口 默认实现
		},
		init: function () {
			if (/MicroMessenger/i.test(navigator.userAgent) && ! /wxwork/i.test(navigator.userAgent)) {
				$(function () {
					func.initfunc();
				})
			} else {
				cookieFunc.removeCookie('minaOpenid');
				cookieFunc.removeCookie('minaLat');
				cookieFunc.removeCookie('minaLng');
			}
		}
	};
	module.exports = func;
});

define('headStyle',['require','exports','module','jquery','toast'],function(require,exports,module){
	var $=require('jquery');
	var toast=require('toast');
	var funcs={
		init:function(){
			$(function(){
				$.ajax({
					url: ctx + '/user/getLoginUserId.do',
					type: 'post',
					success: function(response){
						window.getUserIdComplete = 'yes';
						window.ajaxUserId = response;
						if(response === '0'){//未登录
							$.ajax({//获取申请注册开关 
						        url: ctx+'/user/applyOpen.do',
						        type: "POST",
						        success: function(json) {
						            if(json.result==1 && json.openState){ // 开启注册审核
						            	$('#top_login, #top_regist').css('display','inline-block');
						            }else{
						            	$('#top_login_regist').css('display','inline-block');
						            }
						        },
						    });
							$("#top_login_regist").on("click",function(){ // 未开启注册审核，跳转。登录注册一个页面
								window.location.href=ctx+"/user/main.do?methodName=goLogin&storeid="+WX.storeid+"&salesid="+WX.salesid+"&fromUrl="+encodeURIComponent(window.location.href.replace(window.location.origin+ctx,""));
							});
							$("#top_login").on("click",function(){ // 开启注册审核，跳转。登录页面
								window.location.href=ctx+"/user/main.do?methodName=goLogin&storeid="+WX.storeid+"&salesid="+WX.salesid+"&fromUrl="+encodeURIComponent(window.location.href.replace(window.location.origin+ctx,""));
							});
							$("#top_regist").on("click",function(){ // 开启注册审核，跳转。注册页面
								window.location.href=ctx+"/user/main.do?methodName=goRegister&storeid="+WX.storeid+"&salesid="+WX.salesid+"&fromUrl="+encodeURIComponent(window.location.href.replace(window.location.origin+ctx,""));
							});
						}else{//已登录
							$('.head-user-opera .userHasLogin').css('display','inline-block');
//							会员礼遇----------------------------------------------------------------------------------------------------------------------------------
							$.ajax({
								url: ctx + '/user-center/customerPresentList.do',
								type: 'post',
								success: function(response){
									console.log(response.couponPresent);
									if(response && response.couponPresent && response.couponPresent.length>0){ // 有未领取的优惠礼遇
										var presentIdArry=[];
										var presentIds;
										$('.gift-float-icon').show();
										$.each(response.couponPresent,function(i,e){
											var delHtml = 
												'<div class="gift-coupon-item clearfix" data-id="'+e.presentId+'">'+
													'<div class="coupon-name">'+e.name+'</div>'+
													'<div class="coupon-num">'+e.couponCount+'张</div>'+
												'</div>';
											$('.gift-modal-coupons').append(delHtml);
											presentIdArry.push(e.presentId);
										});
										presentIds=presentIdArry.join(',');
										$('.gift-modal-bottom .gift-modal-btn').click(function(){
												$.ajax({//领取会员礼遇，调用赠送礼遇接口
													url: ctx + '/user-center/receiveCustomerPresent.do',//返回数据:true/false
													data:{presentIds:presentIds},
													success:function(response){
														if(response && response.flag == true){//返回数据:  true/false
															toast(1000,'领取成功');
														}else{
															toast(1000,response.message);
														}
														setTimeout(function(){
															window.location.href = window.location.href + '&isNew=' + new Date().getTime();
														},1000);
													},
													error:function(error){
														toast(1000,'网络连接异常');
													}
												});
											})
										$('.gift-float-icon').click(function(){
											$('.customer-gift-modal').removeClass('hide');
										});
										$('.gift-modal-close').click(function(){
											$('.customer-gift-modal').addClass('hide');
										})
									}
								}
							})
						}
					},
					error: function(){
						window.getUserIdComplete = 'yes';
						window.ajaxUserId = '0';
					}
				})
			});
		}
	}
	module.exports=funcs;
});
require(['jquery', 'init', 'toast', 'weixin', 'headStyle', 'urlParam'], function ($, initFunc, toast, weixinFunc, headFunc, urlParamFunc) {
	initFunc.init();
	weixinFunc.init();
	headFunc.init();
	var couponId = urlParamFunc.getUrlParam('couponId');
	var couponCodeId = urlParamFunc.getUrlParam('couponCodeId');
	var fromUserId = urlParamFunc.getUrlParam('fromUserId');
	var uuid = new Date().getTime();
	$(function () {
		$('#descriptionText').html(datas.description != null ? datas.description : '无');
		var startTime = datas.startTime.toString().substring(0, 8);
		$('.coupon-time-rank').text(startTime.substring(0, 4) + '-' + startTime.substring(4, 6) + '-' + startTime.substring(6, 8));
		var endTime = datas.endTime.toString().substring(0, 8);
		$('.coupon-time-end').text(endTime.substring(0, 4) + '-' + endTime.substring(4, 6) + '-' + endTime.substring(6, 8));

		$('#recive_coupon').html('立即转赠给朋友')
		$('.pos-coupon-detail').append(`
			<div class="fs14 df fd-c mg-b10 mg-b15">
				<img style="width:32px;" src="${resoucePath}/img/coupon/warn.png" />
				<p class="cf60 df mg-t10">本券转赠后，在朋友未领取前，您将暂时无法使用。若超过24小时未被领取，系统将自动返还至您的账户中，赶紧提醒朋友领取吧~</p>
			</div>
		`)
        alert(JSON.stringify(navigator.userAgent))
		if (/MicroMessenger/i.test(navigator.userAgent)) {//微信分享回调
			window.shareOp = {
				success: function (res) {
					alert('分享回调开始')
					if (datas.grantStatus == 0 && datas.grantLock == true) {
						alert('转赠开始')
						$.ajax({
							type: 'POST',
							url: ctx + "/coupon/grantCoupon.do?couponCodeId=" + couponCodeId + '&uuid=' + uuid,
							dataType: 'json',
							error: function () {

							},
							success: function () {
								//优惠券转赠完成后，返回优惠券列表
								alert('转赠成功')
								window.location.href = ctx + '/user-center/main.do?methodName=myCouponList&storeid=' + WX.storeid + '&status=1';
								wx.hideOptionMenu();
							}
						});
					} else {
						//优惠券转赠完成后，返回优惠券列表
						window.location.href = ctx + '/user-center/main.do?methodName=myCouponList&storeid=' + WX.storeid + '&status=1';
					}

				},
				cancel: function (res) { },
				fail: function (res) { }
			};
			WX.weixin.share.resetData = function () {
				WX.weixin.share.img_url = logoUrl;
				//	WX.weixin.share.title = '我分享了'+storeName+'的优惠券，快来领取！';
				if (nickName) {
					WX.weixin.share.title = nickName + '分享了' + headStoreName + '的' + datas.title + '，快来领取！';
				} else {
					WX.weixin.share.title = '我分享了' + headStoreName + '的' + datas.title + '，快来领取！';
				}

				WX.weixin.share.desc = '您的好友赠送给您的优惠券，请尽快领取！';
				WX.weixin.share.link = window.location.origin + '/' + ctx + '/coupon/grant.do?storeid=' + WX.storeid + '&couponId=' + couponId + '&couponCodeId=' + couponCodeId + '&fromUserId=' + fromUserId + '&uuid=' + uuid;
			}

			WX.weixin.share.resetInter = function () {
				var options = WX.weixin.share.getOptions(window.shareOp);
				wx.onMenuShareAppMessage(options);
			}

			wx.ready(function () {
                alert('分享回调开始1111')
				if (datas.grantStatus == 1) { // 转增中优惠券隐藏分享菜单
					wx.hideOptionMenu();
				}
				WX.weixin.resetShareInter();
				WX.weixin.onMenuShareAppMessage(shareOp);
				WX.weixin.onMenuShareTimeline(shareOp);
			});
		}
	})
	//立即领取
	$("#recive_coupon").click(function (ev) {
		$('.share-mask').show();
	});
});
define("toGrant", function(){});

