define(function(require, exports, module){
	var cookieFunc=require("cookies"),
	minaOpenid = cookieFunc.getCookie('minaOpenid'),
	minaLat = cookieFunc.getCookie('minaLat'),
	minaLng = cookieFunc.getCookie('minaLng');
	var funcs = {

		creatMap: function(MapId) { // 创建地图
			var node = document.getElementById(MapId)
			return this.init(node)
		},
		init:function(node) {
            var myLatlng = new qq.maps.LatLng(39.916527, 116.397128);
            var myOptions = {
                zoom: 14,
                center: myLatlng,
                mapTypeId: qq.maps.MapTypeId.ROADMAP,
                mapTypeControl: false,
                panControl: false,
                zoomControl: false,
                scaleControl: false
            }
            var map = new qq.maps.Map(node, myOptions);
            map.myListMarkers = [];

            var customZoomDiv = document.createElement('div');
            customZoomDiv.style.cssText = 'width: 50px;height: 50px;background-position: center center;background-size: 40px 40px;background-repeat: no-repeat;background-image: url(data:image/png;base64,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)';
            customZoomDiv.index = 1; //设置在当前布局中的位置
            customZoomDiv.onclick=function(){
                funcs.getLocation(map, undefined, undefined, false);
            }
            map.controls[qq.maps.ControlPosition.RIGHT_BOTTOM].push(customZoomDiv);
            return map;
		},
		getLocation: function(myMap, yCallback, nCallback, setMark) { // 定位；setMark标识是否设置标记在定位点
			if (minaOpenid) { // 小程序环境使用小程序传参的经纬度
				if (minaLat) { // 小程序定位成功
					if(myMap){
						myMap.setCenter(new qq.maps.LatLng(minaLat, minaLng));
					}
					if(setMark) {
						var marker = new qq.maps.Marker({ //设置marker标记
					        map: myMap,
					        position: new qq.maps.LatLng(minaLat, minaLng),
					        icon: new qq.maps.MarkerImage(resourcePath + '/img/map-location-marker.png', null, null, null, new qq.maps.Size(24, 32))
					    });
						if(myMap.locationMarker) {
							myMap.locationMarker.setMap(null);
						}
						myMap.locationMarker = marker;
					}
					if(typeof(yCallback) != 'undefined'){
						yCallback(minaLat, minaLng);
					}
				}
			} else {
				var geolocation = new qq.maps.Geolocation('TKMBZ-BVW3S-QZGOE-6E7OD-2TGRT-BXBL7', 'bigaka');
				geolocation.getLocation(function(location) { // 定位成功
					if(myMap){
						myMap.setCenter(new qq.maps.LatLng(location.lat, location.lng));
					}
					if(setMark) {
						var marker = new qq.maps.Marker({ //设置marker标记
					        map: myMap,
					        position: new qq.maps.LatLng(location.lat, location.lng),
					        icon: new qq.maps.MarkerImage(resourcePath + '/img/map-location-marker.png', null, null, null, new qq.maps.Size(24, 32))
					    });
						if(myMap.locationMarker) {
							myMap.locationMarker.setMap(null);
						}
						myMap.locationMarker = marker;
					}
					if(typeof(yCallback) != 'undefined'){
						yCallback(location.lat, location.lng);
					}
				}, function() { // 定位失败
					geolocation.getIpLocation(function(_location){ // 获取城市位置
						if(myMap){
							myMap.setCenter(new qq.maps.LatLng(_location.lat, _location.lng));
						}
						if(setMark) {
						    var marker = new qq.maps.Marker({ //设置marker标记
						        map: myMap,
						        position: new qq.maps.LatLng(_location.lat, _location.lng),
						        icon: new qq.maps.MarkerImage(resourcePath + '/img/map-location-marker.png', null, null, null, new qq.maps.Size(24, 32))
						    });
						    if(myMap.locationMarker) {
								myMap.locationMarker.setMap(null);
							}
						    myMap.locationMarker = marker;
						}
						if(typeof(nCallback) != 'undefined'){
							nCallback(_location.lat, _location.lng);
						}
					});
				}, {
					failTipFlag: true
				});
			}
		},
		setMarkers: function(myMap, markerData, clearFlag, focusFlag) { // 设置位置标记，clearFlag标识是否清除之前的标记；focusFlag标识是否地图中心定位到第一个标记
			if(clearFlag) { // 清除之前的标注
				$.each(myMap.myListMarkers, function(index, marker) {
					marker.setMap(null);
				});
				myMap.myListMarkers = [];
			}
			if(focusFlag && markerData[0]) { // 地图中心定位到第一个标记
				myMap.setCenter(new qq.maps.LatLng(markerData[0].lat, markerData[0].lng));
			}else{
				funcs.getLocation(myMap, undefined, undefined, false);
			}
			$.each(markerData,function(index, shop){
				var marker = new qq.maps.Marker({ //设置marker标记
			        map: myMap,
			        position: new qq.maps.LatLng(shop.lat, shop.lng),
			        icon: new qq.maps.MarkerImage(resourcePath + '/img/map-store-location.png')
			    });
				myMap.myListMarkers.push(marker);
			});
		},
		initMap: function(MapId, yCallback, nCallback){
			if(typeof(qq) == 'undefined' || typeof(qq.maps) == 'undefined'){
				return false;
			}else{
				var tempMap = funcs.creatMap(MapId);
				funcs.getLocation(tempMap, yCallback, nCallback, true);
				return tempMap
			}
		}
	};
	module.exports=funcs;
})    
