	/**
	 *  公共记录未读消息 start 
	 *  从您的应用服务器请求，以获取 Token。在本示例中我们直接在下面 hardcode 给 token 赋值。
	 *  var token = getTokenFromAppServer();
	 *  此处直接 hardcode 给 token 赋值，请替换为您自己的 Token。
	 */
define(function(require,exports,module){
	var $=require("jquery");
	var funcs={
		init: function(){
			var RongIMClient=require("crm");
			WX=window.WX||{};
			WX.message={
					flag:false
			};
			// 测试环境 key 8luwapkvu0tdl
			// 正式环境 key 8brlm7ufrsj03
			//初始化。
			RongIMClient.init(window.top.WX.crm.key);
			token = ""; // 获取连接token
			$.ajax({
				type : "post",
				url :  ctx+'/shopCart/getImTokenJson.do',
				async: false,
				success : function(dataJson) {
					if (dataJson.result == 1) {
						try{
							token = dataJson.resultTaken.token;
							// 连接融云服务器。
							RongIMClient.connect(token, {
								onSuccess : function(userId) {
									// 此处处理连接成功。
									console.log("Login successfully." + userId);
									WX.message.flag=true;
								},
								onError : function(errorCode) {
									// 此处处理连接错误。
									console.log("Login failed." + errorCode.value,
											"error message: " + errorCode.name);
								}
							});
						}catch(e){
							console.log("IM初始化失败");
						}
						

					} else {
						console.log("获取token失败");
					}
				},
				error : function() {
					console.log("连接异常");
				}
			});
			
			
			// 设置连接监听状态 （ status 标识当前连接状态）
			// 连接状态
			RongIMClient.setConnectionStatusListener({
				onChanged : function(status) {
					// status:RongIMClient.ConnectionStatusListener.ConnectionStatus 对象
					if(status.value == 0){
						RongIMClient.getInstance().getConversationList();
					}
					console.log(status.value, status.name);
				}
			});
				
			// 消息监听器
			RongIMClient.getInstance().setOnReceiveMessageListener({
				// 接收到的消息
				onReceived : function(message) {
					switch (message.getMessageType()) {
					case RongIMClient.MessageType.TextMessage:
						//doSomeThing
//						while(true){
//							setTimeout('',500);
//							if(WX.message.flag)
//								break;
//						}
						if(WX.message.flag){
							$.ajax({
								type : "post",
								url :  ctx+'/shopCart/messageOper.do',
								async: false,
								data:{storeId:'${storeid}',isRead:'0',operType:'1',employeeId:message.getSenderUserId(),userId:'${userid}',type:1,receiveMess:encodeURI(message.getContent())},
								success : function(data) {
									if (data.result == 1) {
										console.log("聊天记录");
									} else {
										console.log("没有聊天记录");
									}
								},
								error : function() {
									console.log("聊天记录获取异常");
								}
							});
						}
						break;
					case RongIMClient.MessageType.VoiceMessage:
						//doSomeThing
						break;
					case RongIMClient.MessageType.ImageMessage:
						//doSomeThing
						break;
					default:
						//doSomeThing
						break;
					}
				}
			});
		},
		messageCount:function(){
			$(function(){
				$.ajax({
					type : "post",
					url :  ctx+'/shopCart/getMessageCount.do',
					async: false, 
					success : function(data) {
						if (data.result == 1) {
							$("#msgCount").html(data.messageCount);
							if(data.messageCount==0){
								$('.head .circle').css('display','none');
								if($("#myBar").length>0){
									$('.message_icon .circle').hide();
					        		$('.expoint .circle').hide();
								}
							}else if(data.messageCount>0){
								$('.head .circle').css('display','inline-block');
								if($("#myBar").length>0){
									$('.message_icon .circle').show();
					        		$('.expoint .circle').show();
								}
							}
							
							console.log("获取已读记录成功");
						} else {
							console.log("获取已读记录失败");
						}
					},
					error : function() {
						console.log("获取已读记录异常");
					}
				});
			});
		}
	};
	module.exports=funcs;
});
	